import req from './Request.js'
import config from './Config.js'

// 配置baseUrl和拦截器，baseUrl例如 /api
req.baseUrl(config.apiPath).interceptor(res => {
  return true
})

export const login = params => {
  return req.post('user/login', params).then(res => res.data)
}

export const shareTicket = params => {
  return req.post('user/get_groupid', params).then(res => res.data)
}

export const getPhoneNumber = params => {
  return req.post('user/getPhoneNumber', params).then(res => res.data)
}

export const home = {
  banner: params => {
    return req.post('banner/index', params).then(res => res.data)
  },
  all: (params) => {
    return req.post('project/homeall', params).then(res => res.data)
  }
}

export const guide = {
  list: (params) => {
    return req.post('project/guides', params).then(res => res.data)
  },
  detail: (params) => {
    return req.post('guide/detail', params).then(res => res.data)
  }
}

export const me = {
  info: params => {
    return req.post('user/index', params).then(res => res.data)
  },
  update: params => {
    return req.post('user/update', params).then(res => res.data)
  },
  collections: params => {
    return req.post('user/userCollections', params).then(res => res.data)
  },
  orders: params => {
    return req.post('order/index', params).then(res => res.data)
  },
  applyRefund: params => {
    return req.post('order/refundSubmit', params).then(res => res.data)
  },
  submitCommit: params => {
    return req.post('Comment/insert', params).then(res => res.data)
  },
  vipPrice: params => {
    return req.post('order/getVipPrice', params).then(res => res.data)
  },
  vipOrder: params => {
    return req.post('order/vipOrder', params).then(res => res.data)
  },
  vipOrderSendTemplate: params => {
    return req.post('order/sendTemplate', params).then(res => res.data)
  },
  uploadAvatar: (name, filePath, params) => {
    return req.upload('User/uploadAvatar', name, filePath, params).then(res => res.data)
  }
}

export const search = {
  index: params => {
    return req.post('project/index', params).then(res => res.data)
  },
  bytype: params => {
    return req.post('project/newProjects', params).then(res => res.data)
  },
  filter: params => {
    return req.post('project/searchCondition', params).then(res => res.data)
  }
}

export const saveFormId = params => {
  return req.post('user/save_formid', params).then(res => res.data)
}

export const project = {
  detail: params => {
    return req.post('project/detail', params).then(res => res.data)
  },
  comments: params => {
    return req.post('comment/getCommentByPid', params).then(res => res.data)
  },
  reservate: params => {
    return req.post('project/reservations', params).then(res => res.data)
  },
  order: params => {
    return req.post('order/projectOrder', params).then(res => res.data)
  },
  enroll: params => {
    return req.post('project/getEnrollInfo', params).then(res => res.data)
  },
  collect: params => {
    return req.post('project/collect', params).then(res => res.data)
  }
}

export default {
  login,
  shareTicket,
  getPhoneNumber,
  home,
  guide,
  search,
  saveFormId,
  me,
  project
}