// pages/search/search/search.js
import api from '../../../utils/Api.js'

Page({

  /**
   * 页面的初始数据
   */
  data: {
    tags: [],
    seltags: [],
    title: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    api.search.filter().then(res => {
      this.setData({
        tags: res.data.tags
      })
    })
  },
  // 输入框
  inputChnage: function(event){
    let _title = event.detail.value
    this.setData({
      title: _title
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {
    
  },

  submitSearch: function(event) {
    let tags = JSON.stringify(this.data.seltags)
    wx.navigateTo({
      url: '/pages/search/list/list?title=' + this.data.title + "&tags=" + tags,
    })
  },

  /**
   * 选择标签
   */
  selectTags: function(event) {
    let tagIdx = event.target.dataset.idx
    let selectedTags = this.data.seltags
    if (selectedTags.indexOf(tagIdx) == -1) {
      // 加入
      selectedTags.push(tagIdx)
    } else {
      // 根据索引移除长度为1的数组元素
      selectedTags.splice(selectedTags.indexOf(tagIdx), 1)
    }
    this.setData({
      seltags: selectedTags
    })
  }
})