// pages/prjlist/list.js
import api from '../../utils/Api.js'
import Wx from '../../utils/Wx.js'
import Schedule from '../../utils/Schedule.js'
const {
  $Toast
} = require('../../iview/base/index');

Page({
  /**
   * 页面的初始数据
   */
  data: {
    projects: [],
    currentPage: 1,
    loading: true,
    hasMore: true,

    type: ''
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let _type = options.type
    let _ptitle = options.ptitle
    if (_type != null && _type.length > 0) {
      this.setData({
        type: _type
      })
    }
    if (_ptitle!=null && _ptitle.length > 0){
      wx.setNavigationBarTitle({
        title: _ptitle
      })
    }
    this.getListData()
  },

  /**
   * 加载
   */
  getListData: function (callback) {
    const p = this.data.currentPage
    let params = {
      p: p
    }
    if (this.data.type.length > 0) {
      params['type'] = this.data.type
    }
    // 请求数据接口
    api.search.bytype(params).then(res => {
      if (res.code) {
        this.setData({
          hasMore: false,
          loading: false,
          currentPage: 2
        })
        $Toast({
          content: res.msg,
          type: 'error'
        })
      } else {
        let _projects = this.data.projects
        this.setData({
          projects: _projects.concat(res.data),
          loading: false,
          hasMore: res.data && res.data.length > 0 ? true : false,
          currentPage: res.data && res.data.length > 0 ? p : (p - 1)
        })
        typeof callback == "function" && callback()
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
  * 页面相关事件处理函数--监听用户下拉动作
  */
  onPullDownRefresh: function () {
    this.setData({
      projects: [],
      loading: true,
      hasMore: true,
      currentPage: 1
    })
    wx.showNavigationBarLoading()
    wx.showLoading({
      title: '加载中...',
    })
    new Schedule().task(this.getListData).delay(1600).task(() => {
      wx.hideNavigationBarLoading()
      wx.stopPullDownRefresh()
      wx.hideLoading()
    })
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    let that = this
    if (that.data.loading || !that.data.hasMore) {
      return;
    } else {
      let page = that.data.currentPage + 1
      new Schedule().task(() => {
        that.setData({
          loading: true,
          currentPage: page
        })
      }).delay(1000).task(that.getListData)
    }
  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {

  }
})