// pages/me/vip/index.js
import api from '../../../utils/Api.js'
const app = getApp()

Page({
  /**
   * 页面的初始数据
   */
  data: {
    value1: 1,
    value2: 0.1,

    vip_price: 49.9,

    order: {},
    user: {}
  },

  handleChange1({
    detail
  }) {
    this.setData({
      value1: detail.value
    })
  },

  handleChange2({
    detail
  }) {
    this.setData({
      value2: detail.value
    })
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.getUserInfo()
    this.getVipPrice()
  },

  // 获取个人资料
  getUserInfo: function() {
    api.me.info().then(res => {
      if (!res.code) {
        app.globalData.userInfo = res.data
        // 渲染数据
        this.setData({
          user: res.data
        })
      }
    })
  },

  // 获取VIP单价
  getVipPrice: function() {
    api.me.vipPrice().then(res => {
      if (!res.code) {
        this.setData({
          vip_price: res.price
        })
      } else {
        wx.showToast({
          title: res.msg
        })
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {

  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  },

  /**
   * 立即购买/续费
   */
  handleClick: function() {
    let that = this
    let year = this.data.value1
    let params = {
      year: year
    }
    // 获取支付参数
    api.me.vipOrder(params).then(res => {
      if (res.code == 0) {
        that.setData({
          order: res.data
        })
        // 发起微信支付
        wx.requestPayment({
          timeStamp: '' + res.result.timeStamp,
          nonceStr: '' + res.result.nonceStr,
          package: '' + res.result.package,
          signType: '' + res.result.signType,
          paySign: '' + res.result.paySign,
          success: function(ret) {
            console.log(ret)
            if (ret.errMsg === 'requestPayment:ok') {
              that.setOrderPaid(that.data.order.order_id, function(res) {
                // 支付同步回调结果
                console.log("发送模版消息", res)
                // 刷新当前页面
                setTimeout(() => {
                  that.getUserInfo()
                }, 500)
              })
            } else {
              wx.showToast({
                title: ret.errMsg,
              })
            }
          }
        })
      } else {
        wx.showToast({
          title: res.msg,
        })
      }
    })
  },
  
  /**
   * 同步支付结果回调：重置订单状态
   */
  setOrderPaid(id, callback) {
    let params = {
      order_id: id
    }
    api.me.vipOrderSendTemplate(params).then(res => {
      typeof callback == "function" && callback(res)
    })
  }
})