// pages/me/order/index.js
// pages/prjlist/list.js
import api from '../../../utils/Api.js'
import Wx from '../../../utils/Wx.js'
import Schedule from '../../../utils/Schedule.js'
const {
  $Toast
} = require('../../../iview/base/index');

Page({
  /**
   * 页面的初始数据
   */
  data: {
    orders: [],
    currentPage: 1,
    loading: true,
    hasMore: true,

    status: 1,
    cur_oid: 0,
    // 评论Modal
    commentModal: false
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function (options) {
    let _status = options.status
    if (_status != null && _status.length > 0) {
      this.setData({
        status: _status
      })
    }
    this.getListData()
  },

  /**
   * 加载
   */
  getListData: function (callback) {
    const p = this.data.currentPage
    let params = {
      p: p,
      status: this.data.status
    }
    // 请求数据接口
    api.me.orders(params).then(res => {
      if (res.code) {
        this.setData({
          hasMore: false,
          loading: false,
          currentPage: 2
        })
      } else {
        let _orders = this.data.orders
        this.setData({
          orders: _orders.concat(res.data),
          loading: false,
          hasMore: res.data && res.data.length > 0 ? true : false,
          currentPage: res.data && res.data.length > 0 ? p : (p - 1)
        })
        typeof callback == "function" && callback()
      }
    })
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function () {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function () {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function () {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function () {

  },

  /**
  * 页面相关事件处理函数--监听用户下拉动作
  */
  onPullDownRefresh: function () {
    this.setData({
      orders: [],
      loading: true,
      hasMore: true,
      currentPage: 1
    })
    wx.showNavigationBarLoading()
    wx.showLoading({
      title: '加载中...',
    })
    new Schedule().task(this.getListData).delay(500).task(() => {
      wx.hideNavigationBarLoading()
      wx.stopPullDownRefresh()
      wx.hideLoading()
    })
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function () {
    let that = this
    if (that.data.loading || !that.data.hasMore) {
      return;
    } else {
      let page = that.data.currentPage + 1
      new Schedule().task(() => {
        that.setData({
          loading: true,
          currentPage: page
        })
      }).delay(1000).task(that.getListData)
    }
  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function () {
    
  },

  /**
   * 点击进入项目详情页
  */
  handleProjectClick: function(event){
    let pid = event.currentTarget.dataset.pid
    wx.navigateTo({
      url: '/pages/detail/index?id=' + pid,
    })
  },

  /**
  * 切换Tab
  */
  handleChange: function (event) {
    let status = event.detail.key.replace('status-', '')
    this.setData({
      status: status.replace('status-', '')
    })
    wx.startPullDownRefresh()
  },

  /**
   * 申请退款
   */
  _applyRefund: function (id) {
    wx.showLoading({
      title: '申请中...',
    })
    let params = {
      id: id
    }
    // 请求数据接口
    api.me.applyRefund(params).then(res => {
      wx.hideLoading()
      if (res.code) {
        $Toast({
          content: res.msg,
          type: 'error'
        });
      } else {
        wx.startPullDownRefresh()
        $Toast({
          content: res.msg,
          type: 'success'
        });
      }
    })
  },

  /**
  * 按钮点击事件
  */
  handleBtnClick: function (event) {
    let that = this
    let isrefund = event.currentTarget.dataset.isrefund
    let iscomment = event.currentTarget.dataset.iscomment
    let oid = event.currentTarget.dataset.oid
    let status = this.data.status
    console.log(oid, status, isrefund, iscomment)
    if(status==1){
      // 进行中
      if(isrefund==0){
        wx.showModal({
          title: '提示',
          content: '申请退款后需要官方审核成功才能退款，退款则表示取消此次订单，确定退款吗？',
          success: function (res){
            if(res.confirm){
              // 提交退款申请，然后刷新列表  
              that._applyRefund(oid)
            }
          }
        })
      }
    }else if(status=2){
      // 待评价
      if (iscomment == 0) {
        this.setData({
          commentModal: true,
          cur_oid:oid
        })
      }
    } else if (status = 3) {
      // 已完成
 
    }
  },

  /**
   * 评论Modal取消事件
   */
  commentCancel() {
    this.setData({
      commentModal: false
    })
  },

  /**
   * 评论Modal确定事件
   */
  commentConfirm(event) {
    // 设置页面滚动到顶部，防止触发 onReachBottom 事件
    wx.pageScrollTo({
      scrollTop: 0,
      duration: 0
    })
    this.setData({
      commentModal: false,
      currentPage: 1
    })
    wx.startPullDownRefresh()
  }
  
})