// pages/me/index.js
import api from '../../utils/Api.js'
import Config from '../../utils/Config.js'
const app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    user: {}
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    this.getUserInfo()
  },

  toUrl: function (event) {
    wx.navigateTo({
      url: event.currentTarget.dataset.url,
    })
  },

  // 获取个人资料
  getUserInfo: function() {
    api.me.info().then(res => {
      if (!res.code) {
        app.globalData.userInfo = res.data
        // 渲染数据
        this.setData({
          user: res.data
        })
      }
    })
  },

  // 商家合作
  gotoShopJoin: function (event) {
    wx.navigateTo({
      url: '/pages/webview/index?url=' + Config.shopJoinPath,
    })
  },

  // 我的订单
  handleOrderClick: function (event) {
    let status = event.currentTarget.dataset.status
    wx.navigateTo({
      url: '/pages/me/order/index?status=' + status,
    })
  }
})