// pages/index.js
import api from '../../utils/Api.js'
import Config from '../../utils/Config.js'

const app = getApp()
const {
  $Message
} = require('../../iview/base/index');

Page({

  /**
   * 页面的初始数据
   */
  data: {
    news: [],
    heats: [],
    businesses: [],
    guides: [],

    banners: []
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {
    this.getHomeData()
    this.getBannerData()
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    // 检查用户是否登陆
    this.checkUserLogin()

    wx.showShareMenu({
      withShareTicket: true,
      success: function(ret) {
        console.log('shareTickets:', ret)
      }
    })
  },

  /**
   * 用户资料授权
   */
  checkUserLogin: function(callback) {
    if (app.globalData.userInfo == null) {
      api.me.info().then(res => {
        if (res.code == 0) {
          app.globalData.userInfo = res.data
        } else {
          $Message({
            content: '请授权登录美行者亲子游',
            type: 'warning'
          })
          setTimeout(() => {
            wx.navigateTo({
              url: '/pages/auth/index',
            })
          }, 800)
        }
      })
    }

    // console.log(wx.getStorageSync('token') )
    // if (!wx.getStorageSync('token')) {
    //   $Message({
    //     content: '请授权登录美行者亲子游',
    //     type: 'warning'
    //   })
    //   setTimeout(()=>{
    //     wx.navigateTo({
    //       url: '/pages/auth/index',
    //     })
    //   }, 800)
    // } else {
    //   api.me.info().then(res => {
    //     if(res.code == 0){
    //       app.globalData.userInfo = res.data
    //     }else{
    //       $Message({
    //         content: res.msg,
    //         type: 'error'
    //       })
    //     }
    //   })
    // }
  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {
    wx.showNavigationBarLoading()
    this.getHomeData(() => {
      wx.hideNavigationBarLoading()
      wx.stopPullDownRefresh()
    })
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },
  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  },

  getHomeData: function(callback) {
    api.home.all().then(res => {
      this.setData({
        news: res.data.newProjects,
        heats: res.data.heatProjects,
        businesses: res.data.businessProjects,
        guides: res.data.guides
      })
      typeof callback == "function" && callback()
    })
  },

  getBannerData: function() {
    api.home.banner({
      token: app.globalData.token
    }).then(res => {
      this.setData({
        banners: res.data
      })
    })
  },

  // 最新活动，爆款专区  更多项目
  gotoMoreProjects: function(event) {
    let _type = event.target.dataset.type
    let _ptitle = event.target.dataset.name
    wx.navigateTo({
      url: '/pages/prjlist/list?type=' + _type + '&ptitle=' + _ptitle,
    })
  },

  // 更多：按分类筛选
  gotoSearchProjects: function(event) {
    let _catalog = event.target.dataset.catalog
    let _ptitle = event.target.dataset.name
    wx.navigateTo({
      url: '/pages/search/list/list?catalog=' + _catalog + '&ptitle=' + _ptitle,
    })
  },

  // 跳转详情页
  handleProjectDetail: function(event) {
    const id = event.currentTarget.dataset.id
    wx.navigateTo({
      url: '/pages/detail/index?id=' + id,
    })
  },

  // 查看攻略详情
  handleGuideDetail: function(event) {
    let type = event.currentTarget.dataset.type
    let content = event.currentTarget.dataset.content
    let url = Config.mobPath
    if (type == '1') {
      url = url + "Guide/read/id/" + content
    } else {
      url = content
    }
    wx.navigateTo({
      url: '/pages/webview/index?url=' + url + '&t=攻略详情',
    })
  }

})