// pages/guide/index.js
import api from '../../utils/Api.js'
import Config from '../../utils/Config.js'
import Schedule from '../../utils/Schedule.js'

Page({

  /**
   * 页面的初始数据
   */
  data: {
    guides: [],
    iptValue: '',
    recover: 'none',
    currentPage: 1,
    loading: true,
    hasMore: true,
    i: 0
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    this.getListData()
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {

  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {
    this.setData({
      guides: [],

      loading: true,
      hasMore: true,
      currentPage: 1
    })
    wx.showNavigationBarLoading()
    wx.showLoading({
      title: '加载中...',
    })
    new Schedule().task(this.getListData).delay(1600).task(() => {
      wx.hideNavigationBarLoading()
      wx.stopPullDownRefresh()
      wx.hideLoading()
    })
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {
    let that = this
    if (that.data.loading || !that.data.hasMore) {
      return;
    } else {
      let page = that.data.currentPage + 1
      new Schedule().task(() => {
        that.setData({
          loading: true,
          currentPage: page
        })
      }).delay(1000).task(that.getListData)
    }
  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  },

  // 查看攻略详情
  handleGuideDetail: function(event) {
    let type = event.currentTarget.dataset.type
    let content = event.currentTarget.dataset.content
    let url = Config.mobPath
    if (type == '1') {
      url = url + "Guide/read/id/" + content
    } else {
      url = content
    }
    wx.navigateTo({
      url: '/pages/webview/index?url=' + url + '&t=攻略详情',
    })
  },

  getListData: function(callback) {
    const p = this.data.currentPage
    api.guide.list({
      p
    }).then(res => {
      if (res.code) {
        this.setData({
          hasMore: false,
          loading: false
        })
      } else {
        this.setData({
          guides: this.data.guides.concat(res.data),
          loading: false,
          hasMore: res.data && res.data.length > 0 ? true : false,
          currentPage: res.data && res.data.length > 0 ? p : (p - 1)
        })
        typeof callback == "function" && callback()
      }
    })
  },
  /* 美行攻略 的 重置input框的文本*/
  clearContent: function () {
    this.setData({
      iptValue: ''
    })
  },
  /* 美行攻略 的 搜索请求*/
  searchFun: function (e,callback) {
    // 显示“取消”按钮
    this.setData({ recover: "block"})
    // 开始请求
    const p = this.data.currentPage
    let title = e.detail.value
    api.guide.list({
      title, p
    }).then(res => {
      if (res.code) {
        this.setData({
          hasMore: false,
          loading: false
        })
      } else {
        this.setData({
          guides: this.data.guides = res.data,
          loading: false,
          hasMore: res.data && res.data.length > 0 ? true : false,
          currentPage: res.data && res.data.length > 0 ? p : (p - 1)
        })
        typeof callback == "function" && callback()
      }
    })
  },
  recoverListData: function (callback){
    this.setData({ recover: "none" })
    // 同时删除搜索框的内容
    this.clearContent()
    // 开始重新渲染数据
    const p = this.data.currentPage
    api.guide.list({
      p
    }).then(res => {
      if (res.code) {
        this.setData({
          hasMore: false,
          loading: false
        })
      } else {
        this.setData({
          guides: this.data.guides = res.data,
          loading: false,
          hasMore: res.data && res.data.length > 0 ? true : false,
          currentPage: res.data && res.data.length > 0 ? p : (p - 1)
        })
        typeof callback == "function" && callback()
      }
    })
  }
})