// pages/detail/appointment/index.js
import api from '../../../utils/Api.js'
import Schedule from '../../../utils/Schedule.js'
import Wx from '../../../utils/Wx.js'
const {
  $Toast
} = require('../../../iview/base/index');
const app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    nickname: {},
    detail: {},

    phone: '',
    date: '',
    remark: '',
    loading: false,
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    if (options.id) {
      this.setData({
        id: options.id
      })
    }
  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {
    let that = this
    wx.showNavigationBarLoading()
    wx.showLoading({
      title: '加载中...',
    })
    new Schedule().task(this.getDetailData).delay(1200).task(() => {
      wx.hideNavigationBarLoading()
      wx.hideLoading()
    })
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {
    this.setData({
      nickname: app.globalData.userInfo.nickname
    })
    if (app.globalData.userInfo.phone && app.globalData.userInfo.phone.length > 0) {
      this.setData({
        phone: app.globalData.userInfo.phone
      })
    }
  },

  getDetailData: function() {
    api.project.detail({
      id: this.data.id
    }).then(res => {
      if (!res.code) {
        console.log(res.data)
        this.setData({
          detail: res.data
        })
      }
    })
  },
  // 打开位置
  handleMap: function() {
    wx.openLocation({
      latitude: parseFloat(this.data.detail.latitude),
      longitude: parseFloat(this.data.detail.longitude),
    })
  },
  handlePhoneAuth: function(event) {
    Wx.login().then(res => {
      let encryptedData = event.detail.encryptedData
      let iv = event.detail.iv
      this.decodePhoneData(res.code, encryptedData, iv)
    })
  },

  /**
   * 解密手机号数据
   */
  decodePhoneData: function(code, encryptedData, iv) {
    let that = this
    api.getPhoneNumber({
      code: code,
      encryptedData: encryptedData,
      iv: iv
    }).then(res => {
      if (!res.code) {
        $Toast({
          content: '手机号授权成功',
          type: 'success'
        });
        this.setData({
          phone: res.data.phone
        })
        // 将刚拿到的手机号码放到全局数据中，否则phone数据只会是当前页面数据
        if (app.globalData.userInfo) {
          app.globalData.userInfo.phone = res.data.phone
        }
      } else {
        $Toast({
          content: '手机号授权失败',
          type: 'error'
        });
      }
    })
  },

  handleNickname: function(event) {
    this.setData({
      nickname: event.detail.value
    })
  },

  handleDateChange: function(e) {
    this.setData({
      date: e.detail.value
    })
  },

  handleRemark: function(event) {
    this.setData({
      remark: event.detail.value
    })
  },
  handleSubmit: function() {
    if (!this.data.nickname || !this.data.phone || !this.data.date) {
      $Toast({
        content: '请完善必要信息',
        type: 'error'
      });
      return
    }
    if (this.data.phone.length == 0) {
      $Toast({
        content: '请授权手机号',
        type: 'error'
      });
      return
    }
    api.project.reservate({
      pid: this.data.id,
      nickname: this.data.nickname,
      phone: this.data.phone,
      expectation_time: this.data.date,
      remark: this.data.remark
    }).then(res => {
      $Toast({
        content: res.msg,
        type: !res.code ? 'success' : 'error'
      });
      if (!res.code) {
        setTimeout(() => {
          wx.navigateBack({
            delta: 1
          })
        }, 800)
      }
    })
  }
})