// components/search-filter/index.js
import api from '../../utils/Api.js'

Component({
  /**
   * 组件的属性列表
   */
  properties: {

  },

  /**
   * 组件的初始数据
   */
  data: {
    types: [],
    catalogs: [],
    regions: [],
    tags: [],
    filter_idx: 0,
    selected: {
      type: '0',
      city: '0',
      catalog: '0',
      region: '0',
      tags: []
    },
    selected_titles: {
      type: '全部项目',
      catalog: '全部分类',
      region: '全部地域'
    }
  },
  /**
   * 组件渲染完后的方法
   */
  ready() {
    api.search.filter().then(res => {
      this.setData({
        types: res.data.type,
        catalogs: res.data.catalog_id,
        regions: res.data.city,
        tags: res.data.tags
      })
    })
  },

  /**
   * 组件的方法列表
   */
  methods: {
    // 点击筛选项
    filterTap: function(event) {
      let idx = event.target.dataset.idx;
      if (idx == this.data.filter_idx) {
        this.setData({
          filter_idx: 0
        })
      } else {
        this.setData({
          filter_idx: idx
        })
      }
    },
    // 选择项目、分类、地域的选择项
    selectFilter: function(event) {
      let idx = event.target.dataset.idx
      let name = event.target.dataset.name
      let _selected = this.data.selected
      let _selected_titles = this.data.selected_titles
      if (this.data.filter_idx == 1) {
        _selected.type = idx
        _selected_titles.type = name
      } else if (this.data.filter_idx == 2) {
        _selected.catalog = idx
        _selected_titles.catalog = name
      } else if (this.data.filter_idx == 3) {
        if (name == '国内' || name == '国外') {
          // 国内国外筛选
          _selected.region = idx
          _selected.city = '0'
        } else {
          // 城市筛选
          _selected.city = idx
          _selected.region = '0'
        }
        _selected_titles.region = name
      }
      this.setData({
        selected: _selected,
        selected_titles: _selected_titles
      })
      this.setData({
        filter_idx: 0
      })
      this._submitFilter()
    },
    // 选择多个标签
    selectTags: function(event) {
      let tagIdx = event.target.dataset.idx
      let selectedTags = this.data.selected.tags
      if (selectedTags.indexOf(tagIdx) == -1) {
        // 加入
        selectedTags.push(tagIdx)
      } else {
        // 根据索引移除长度为1的数组元素
        selectedTags.splice(selectedTags.indexOf(tagIdx), 1)
      }
      let _selected = this.data.selected
      _selected.tags = selectedTags
      this.setData({
        selected: _selected
      })
    },
    // 取消选择标签
    cancelSelectTags: function(event) {
      let _selected = this.data.selected
      if (_selected.tags.length > 0) {
        _selected.tags = []
        this.setData({
          selected: _selected
        })
        this.setData({
          filter_idx: 0
        })
        this._submitFilter()
      } else {
        this.setData({
          filter_idx: 0
        })
      }
    },
    // 确定选择标签
    ensureSelectTags: function(event) {
      this._submitFilter()
      this.setData({
        filter_idx: 0
      })
    },
    // 提交筛选数据请求
    _submitFilter() {
      console.log(this.data.selected )
      let myEventDetail = {
        filters: this.data.selected
      } // detail对象，提供给事件监听函数
      let myEventOption = {} // 触发事件的选项
      this.triggerEvent('filter', myEventDetail, myEventOption)
    },
    // 点击蒙层关闭筛选弹框
    closeFilter: function(event) {
      this.setData({
        filter_idx: 0
      })
    },
    // 阻止子元素冒泡点击事件到付元素
    preventEvent: function(event) {

    }
  }
})