// components/banners/index.js
const Util = require('../../utils/Util.js')
const formBehavior = require('../../behaviors/form.js')
const app = getApp()

Component({
  behaviors: [formBehavior],

  /**
   * 组件的属性列表
   */
  properties: {
    api: {
      type: String,
      value: 'banner/index'
    },
    banners: {
      type: Object,
      value: {}
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    banners: [],
    indicatorDots: true,
    autoplay: false,
    interval: 2500,
    duration: 500
  },

  attached() {

  },

  /**
   * 组件的方法列表
   */
  methods: {
    _tapBanner(event) {
      let type = event.currentTarget.dataset.type
      let url = event.currentTarget.dataset.url
      let type_text = '网页详情'
      if (type == 1 && Util.isString(url)) {
        // 小程序页面
        wx.navigateTo({
          url: url,
        })
      } else if (type == 2 && Util.isString(url)) {
        // 网页链接
        wx.navigateTo({
          url: '/pages/webview/index?url=' + url + '&t=' + type_text,
        })
      } else {
        // 预览大图
        let image = event.currentTarget.dataset.image
        let imgs = []
        for (let i = 0; i < this.data.banners.length; i++) {
          imgs.push(this.data.banners[i].image)
        }
        wx.previewImage({
          urls: imgs,
          current: image
        })
      }
    }
  }
})