import api from '../utils/Api.js'

module.exports = Behavior({
  behaviors: [],
  properties: {},
  data: {
    formApi: 'user/save_formid',
    formEnable: false
  },
  attached: function() {},
  methods: {
    /**
     * 绑定页面中收集 formId 的 submit 事件
     */
    __collectFormId: function(event) {
      let formId = event.detail.formId
      if (this.formEnable) {
        this.__postFormId(formId)
      }
    },

    /**
     * 提交 formId 到服务器
     */
    __postFormId: function(formId) {
      let that = this
      api.saveFormId({
        formid: formId
      }).then(res => {
        console.log('colletion formid: ', res)
      })
    }
  }
})