//app.js
import api from './utils/Api.js'

App({
  onLaunch: function(options) {
    this.options = options
    // 用户登录
    // this.checkUserLogin()
  },

  onShow: function(options) {
    wx.showShareMenu({
      withShareTicket: true,
      success: function(ret) {
        console.log('shareTickets:', ret)
      }
    })
  },

  /**
   * 用户资料授权
   */
  checkUserLogin: function(callback) {
    let _app = this
    if (!wx.getStorageSync('token')) {
      wx.navigateTo({
        url: '/pages/auth/index',
      })
    } else {
      api.me.info().then(res => {
        _app.globalData.userInfo = res.data
      })
    }
  },

  globalData: {
    userInfo: null
  }
})