import req from './Request.js'
import config from './Config.js'

// 配置baseUrl和拦截器，baseUrl例如 /api
req.baseUrl(config.apiPath).interceptor(res => {
  return true
})

export const login = params => {
  return req.post('user/login', params).then(res => res.data)
}

export const shareTicket = params => {
  return req.post('user/get_groupid', params).then(res => res.data)
}

export const home = {
  banner: params => {
    return req.post('banner/index', params).then(res => res.data)
  },
  all: (params) => {
    return req.post('project/homeall', params).then(res => res.data)
  }
}

export const guide = {
  list: (params) => {
    return req.post('project/guides', params).then(res => res.data)
  },
  detail: (params) => {
    return req.post('guide/detail', params).then(res => res.data)
  }
}

export const me = {
  info: params => {
    return req.post('user/index', params).then(res => res.data)
  },
  update: params => {
    return req.post('user/update', params).then(res => res.data)
  },
  collections: params => {
    return req.post('user/userCollections', params).then(res => res.data)
  },
  vipPrice: params => {
    return req.post('order/getVipPrice', params).then(res => res.data)
  },
  vipOrder: params => {
    return req.post('order/vipOrder', params).then(res => res.data)
  }
}

export const search = {
  index: params => {
    return req.post('project/index', params).then(res => res.data)
  },
  filter: params => {
    return req.post('project/searchCondition', params).then(res => res.data)
  }
}

export default {
  login,
  shareTicket,
  home,
  guide,
  search
}