// pages/index.js
import api from '../../utils/Api.js'
const app = getApp()

Page({

  /**
   * 页面的初始数据
   */
  data: {
    news: [],
    heats: [],
    businesses: [],
    guides: []
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {

  },

  /**
   * 生命周期函数--监听页面初次渲染完成
   */
  onReady: function() {
    this.getHomeData()
  },

  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {

  },

  /**
   * 生命周期函数--监听页面隐藏
   */
  onHide: function() {

  },

  /**
   * 生命周期函数--监听页面卸载
   */
  onUnload: function() {

  },

  /**
   * 页面相关事件处理函数--监听用户下拉动作
   */
  onPullDownRefresh: function() {
    wx.showNavigationBarLoading()
    this.getHomeData(() => {
      wx.hideNavigationBarLoading()
      wx.stopPullDownRefresh()
    })
  },

  /**
   * 页面上拉触底事件的处理函数
   */
  onReachBottom: function() {

  },

  /**
   * 用户点击右上角分享
   */
  onShareAppMessage: function() {

  },

  getHomeData: function(callback) {
    api.home.all().then(res => {
      this.setData({
        news: res.data.newProjects,
        heats: res.data.heatProjects,
        businesses: res.data.businessProjects,
        guides: res.data.guides
      })
      typeof callback == "function" && callback()
    })
  }
})