// components/banners/index.js
import api from '../../utils/Api.js'
const Util = require('../../utils/Util.js')
const formBehavior = require('../../behaviors/form.js')
const app = getApp()

Component({
  behaviors: [formBehavior],

  /**
   * 组件的属性列表
   */
  properties: {
    api: {
      type: String,
      value: 'banner/index'
    },
    banners: {
      type: Object,
      value: {}
    }
  },

  /**
   * 组件的初始数据
   */
  data: {
    banners: [],
    indicatorDots: true,
    autoplay: false,
    interval: 5000,
    duration: 1000
  },

  attached() {
    if (!this.data.banners.length) {
      this._getBannerData()
    }
  },

  /**
   * 组件的方法列表
   */
  methods: {
    _getBannerData() {
      api.home.banner({
        token: app.globalData.token
      }).then(res => {
        this.setData({
          banners: res.data
        })
      })
    },
    _tapBanner(event) {
      let oid = event.currentTarget.dataset.oid
      let type = event.currentTarget.dataset.type
      let url = event.currentTarget.dataset.url
      let type_text = event.currentTarget.dataset.txt
      if (type == 1) {
        wx.navigateTo({
          url: '/pages/course/single/index?id=' + oid,
        })
      } else if (type == 2) {
        wx.navigateTo({
          url: '/pages/course/multiple/index?id=' + oid,
        })
      } else if (type == 3) {
        wx.navigateTo({
          url: '/pages/courses/coach/index?id=' + oid,
        })
      } else if (type == 4 && Util.isString(url)) {
        wx.navigateTo({
          url: '/pages/webview/index?url=' + url + '&t=' + type_text,
        })
      }
    }
  }
})