const Util = require('../utils/Util.js')
const app = getApp()

module.exports = Behavior({
  behaviors: [],
  properties: {},
  data: {},
  attached: function () { },
  methods: {
    /**
     * 获取手机号按钮回调事件
     */
    __getPhoneNumber: function (event, callback) {
      let that = this
      wx.login({
        success: function (res) {
          let encryptedData = event.detail.encryptedData
          let iv = event.detail.iv
          that.__decodePhoneData(res.code, encryptedData, iv, function (res) {
            typeof callback == "function" && callback(res)
          })
        }
      })
    },
    
    /**
     * 解密用户数据
     */
    __decodePhoneData: function (code, encryptedData, iv, callback) {
      let that = this
      app.requestData('user/auth_phone', Util.sign({
        token: app.globalData.token,
        code: code,
        encryptedData: encryptedData,
        iv: iv
      }), 'POST', function (res) {
        if (!res.code) {
          typeof callback == "function" && callback(res)
        } else {
          app.showToastWithImg('授权失败')
        }
      })
    }
  }
})