const Util = require('../utils/Util.js')
const app = getApp()

module.exports = Behavior({
  behaviors: [],
  properties: {},
  data: {
    formApi: 'user/save_formid'
  },
  attached: function () { },
  methods: {
    /**
     * 绑定页面中收集 formId 的 submit 事件
     */
    __collectFormId: function (event) {
      let formId = event.detail.formId
      let token = app.globalData ? app.globalData.token : ''
      this.__postFormId(formId, token)
    },

    /**
     * 提交 formId 到服务器
     */
    __postFormId: function (formId, token) {
      let that = this
      app.requestData(that.data.formApi, Util.sign({
        token: token,
        formid: formId
      }), 'POST', function (res) {
        console.log('colletion formid: ', res)
      })
    }
  }
})