//app.js
import api from './utils/Api.js'

App({
  onLaunch: function(options) {
    this.options = options
    // 用户登录
    // this.checkUserLogin()
  },

  onShow: function(options) {
    wx.showShareMenu({
      withShareTicket: true,
      success: function(ret) {
        console.log('shareTickets:', ret)
      }
    })
  },

  /**
   * 用户资料授权
   */
  checkUserLogin: function(callback) {
    let _app = this
    if (_app.globalData.userInfo == null) {
      _app.requestWxLogin(function(res) {
        typeof callback == "function" && callback()
      })
    } else {
      console.log("用户已登录", _app.globalData.userInfo)
      typeof callback == "function" && callback()
    }
  },

  /**
   * 请求微信授权登陆
   */
  requestWxLogin: function(callback) {
    let that = this
    wx.login({
      success: function(res) {
        if (res.code) {
          //发起网络请求
          let wxcode = res.code
          wx.getUserInfo({
            withCredentials: true,
            lang: 'zh_CN',
            success: function(data) {
              console.info("1成功获取用户返回数据", wxcode, data);
              that.requestServerLogin(wxcode, data, callback)
            },
            fail: function() {
              console.info("1授权失败返回数据");
              // 显示提示弹窗
              wx.showModal({
                title: '授权失败',
                content: '你的微信授权未开启，将无法使用小程序！',
                success: function(res) {
                  if (res.confirm) {
                    wx.openSetting({
                      success: function(data) {
                        if (data && data.authSetting["scope.userInfo"] == true) {
                          wx.getUserInfo({
                            withCredentials: true,
                            success: function(data) {
                              console.info("3成功获取用户返回数据");
                              that.requestServerLogin(wxcode, data, callback)
                            },
                            fail: function() {
                              console.info("3授权失败返回数据");
                            }
                          });
                        }
                      },
                      fail: function() {
                        console.info("设置失败返回数据");
                      }
                    });
                  } else if (res.cancel) {
                    console.log('用户坚持取消授权')
                  }
                }
              });
            }
          });
        }
      },
      fail: function() {
        console.info("登录失败返回数据");
      }
    });
  },

  /**
   * 请求获取群id openGid 所需参数
   */
  requestShareTicket: function(callback) {
    let that = this
    wx.login({
      success: function(res) {
        let wxcode = res.code
        wx.getShareInfo({
          shareTicket: that.options.shareTicket,
          success: function(res) {
            that.requestServerWithShareData(wxcode, {
              encryptedData: res.encryptedData,
              iv: res.iv
            }, callback)
          }
        })
      }
    })
  },

  /**
   * 请求服务器登陆
   */
  requestServerLogin: function(wxcode, data, callback) {
    let _app = this
    api.login({
      code: wxcode,
      signature: data.signature,
      rawData: data.rawData,
      encryptedData: data.encryptedData,
      iv: data.iv,
      scene: _app.options.query && _app.options.query.scene ? decodeURIComponent(_app.options.query.scene) : ''
    }).then(res => {
      if (!res.code) {
        _app.globalData.userInfo = res.user
        _app.globalData.token = res.token
        typeof callback == "function" && callback(res.user)
      }
      if (_app.options.scene == 1044 && _app.options.shareTicket) {
        _app.requestShareTicket(function(ret) {
          console.log("Request Share Ticket", ret)
        })
      }
    })
  },

  /**
   * 请求服务器解析数据获取 openGid
   */
  requestServerWithShareData(wxcode, data, callback) {
    let _app = this
    api.shareTicket({
      token: _app.globalData.token,
      code: wxcode,
      encryptedData: data.encryptedData,
      iv: data.iv
    }).then(res => res.data).then(res => {
      typeof callback == "function" && callback(res)
    })
  },

  globalData: {
    userInfo: null,
    token: ''
  }
})