$.extend( true, $.fn.dataTable.defaults, {
    "order": [[ 0, "desc" ]],
    "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "全部"]],
    "language": {
        "lengthMenu": "每页显示: _MENU_ ",
        "search": "搜索:",
        "zeroRecords": "没有适合条件的数据",
        "emptyTable": "暂无数据",
        "info": "共: _TOTAL_ 条. 当前: _START_ ~ _END_ ",
        "infoEmpty": "共: 0 条. 当前: 0 ~ 0 ",
        "infoFiltered": "(从共 _MAX_ 条数据中筛选)",
        "paginate": {
            "first": "第一页",
            "last": "最后一页",
            "previous": "上一页",
            "next": "下一页",
        }
    }
});

jQuery(document).ready(function($) {
    // 专辑列表
    var table = $('#activity-table').DataTable({
        "pageLength": 1,
        "columnDefs": [
            {
                "targets": [ 1 ],
                "orderable": false,
                "searchable": true
            },
            {
                "targets": [ 3 ],
                "orderable": false,
                "searchable": true
            },
            {
                "targets": [ 5 ],
                "orderable": false,
                "searchable": true
            },
            {
                "targets": [ 7 ],
                "orderable": false,
                "searchable": false
            }
        ]
    });

    // 视频列表
    $('#video-table').DataTable({
        "pageLength": 10,
        "columnDefs": [
            {
                "targets": [ 2 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 5 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 6 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 10 ],
                "orderable": false,
                "searchable": false
            }
        ]
    });

    // 专辑详情页视频列表
    $('#album-video-table').DataTable({
        "pageLength": 10,
        "columnDefs": [
            {
                "targets": [ 4 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 7 ],
                "orderable": false,
                "searchable": false
            }
        ]
    });

    // 视频详情页评论 & 喜欢
    $('#video-comment-table').DataTable({
        "pageLength": 6,
        "columnDefs": [
            {
                "targets": [ 2 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 3 ],
                "orderable": false
            }
        ]
    });
    $('#video-favorite-table').DataTable({
        // "searching": false,
        // "lengthChange": false,
        "pageLength": 6,
        "columnDefs": [
            {
                "targets": [ 2 ],
                "orderable": false,
                "searchable": false
            }
        ]
    });

    // 用户列表
    $('#user-table').DataTable({
        "pageLength": 10,
        "columnDefs": [
            {
                "targets": [ 7 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 3 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 4 ],
                "orderable": false,
                "searchable": false
            }
        ]
    });

    // 用户详情页评论 & 喜欢
    $('#user-comment-table').DataTable({
        "pageLength": 8,
        "columnDefs": [
            {
                "targets": [ 3 ],
                "orderable": false
            }
        ]
    });
    $('#user-favorite-table').DataTable({
        "pageLength": 8,
        "columnDefs": []
    });

    // 评论列表
    $('#comment-table').DataTable({
        "pageLength": 10,
        "columnDefs": [
            {
                "targets": [ 7 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 4 ],
                "orderable": false
            }
        ]
    });

    // 反馈列表
    $('#feedbacks-table').DataTable({
        "pageLength": 10,
        "columnDefs": [
            {
                "targets": [ 7 ],
                "orderable": false,
                "searchable": false
            },
            {
                "targets": [ 3 ],
                "orderable": false
            }
        ]
    });
});