$(function () {
    $('[data-toggle="tooltip"]').tooltip();

    // 显示二维码
    $('.btn-qr').unbind('click').bind('click', function () {
        var _this = $(this);
        var oid = _this.attr('oid');
        var obj = _this.attr('obj');
        showQRDialog(obj, oid);
    });

    // 右侧详情
    $('.right-show').unbind('click').bind('click', function (event) {
        event.stopPropagation();
        event.preventDefault();
        document.getElementById('right-detail-content').innerHTML = "";
        var url = "/admin/Space/read";
        var oid = $(this).attr('oid');
        showRightDetail(function () {
            $.get(url + "/id/" + oid, function (res) {
                var res = JSON.parse(res);
                console.log(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        type: 'error'
                    });
                } else {
                    var html = template('space', res.data);
                    document.getElementById('right-detail-content').innerHTML = html;
                }
            });
        });
    });

    // 删除
    $('.btn-delete').unbind('click').bind('click', function (event) {
        event.preventDefault();
        var url = "/admin/Space/delete";
        var _this = $(this);
        var oid = _this.attr('oid');
        showDialog("删除群空间", "确定删除群空间？", function () {
            $.get(url + "/id/" + oid, function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    window.location.reload();
                }
            });
        });
    });

    // 表单
    $('#space-create-form, #space-update-form').validationEngine('attach', {
        promptPosition: 'centerRight',
        binded: true,
        scroll: true,
        autoHidePrompt: true,
    });

    // 保存
    $('#btn-save').unbind('click').bind('click', function (event) {
        event.preventDefault();
        var qun_nickname = $('#qun_nickname').val();
        var valid = $('#space-create-form').validationEngine('validate');
        if (valid) {
            if (qun_nickname && qun_nickname != 0) {
                $('#space-create-form')[0].submit();
            } else {
                new PNotify({
                    title: '提示',
                    text: '请选择群'
                });
            }
        }
    });

    // 选择机器人
    $('#robot').unbind('change').bind('change', function (event) {
        event.preventDefault();
        var _this = $(this);
        var robot_id = _this.val();
        if (robot_id && robot_id != 0) {
            getGroups(robot_id);
        } else {
            $('#qun_nickname').html('');
        }
    });

    // 添加空间用户
    $('.btn-create-user').unbind('click').bind('click', function (event) {
        event.preventDefault();
        var _modal = $('#create-user-modal').modal('show');
        _modal.find('.btn-save').unbind('click').bind('click', function () {
            var _this = $(this);
            var oid = _this.attr('oid');
            var nickname = $.trim(_modal.find('#nickname').val());
            if (nickname == '') {
                new PNotify({
                    title: '提示',
                    text: '请填写必要信息'
                });
                return;
            };
            var $btn = _this.button('loading');
            addUser(oid, nickname, function () {
                _modal.modal('hide');
                $btn.button('reset');
            });
        });
    });

    // 设置，取消群空间管理员
    $('.btn-setadmin-user').unbind('click').bind('click', function (event) {
        event.preventDefault();
        var url = "/admin/Space/setUserAdmin";
        var uid = $(this).attr('oid');
        var role = $(this).attr('role');

        showDialog("设置管理员", "设置/取消 该成员为群空间管理员？", function () {
            $.post(url, {id:uid, role:role}, function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    window.location.reload();
                }
            });
        });
    });

    // 删除空间用户
    $('.btn-delete-user').unbind('click').bind('click', function (event) {
        event.preventDefault();
        var _this = $(this);
        var oid = _this.attr('oid');
        showDialog("删除群空间用户", "确定删除该群空间用户？", function () {
            deleteUser(oid);
        });
    });

    // 空间头像
    var avatarUploader = Qiniu.uploader({
        runtimes: 'html5,flash,html4', // 上传模式，依次退化
        browse_button: 'avatar-file-btn', // 上传选择的点选按钮，必需
        uptoken_url: '/admin/upload/uptoken', // Ajax请求uptoken的Url
        get_new_uptoken: false, // 设置上传文件的时候是否每次都重新获取新的uptoken
        domain: 'http://botfile.imgondar.com', // bucket域名，下载资源时用到，必需
        max_file_size: '100mb', // 最大文件体积限制
        flash_swf_url: '/static/plupload/Moxie.swf', //引入flash，相对路径
        max_retries: 3, // 上传失败最大重试次数
        dragdrop: true, // 开启可拖曳上传
        drop_element: 'chating-text', // 拖曳上传区域元素的ID，拖曳文件或文件夹后可触发上传
        chunk_size: '4mb', // 分块上传时，每块的体积
        auto_start: true, // 选择文件后自动上传，若关闭需要自己绑定事件触发上传
        multi_selection: false,
        unique_names: true,
        filters: {
            mime_types: [{
                    title: "Image files",
                    extensions: "jpg,gif,png,jpeg"
                } // 限定jpg,gif,png后缀上传
            ]
        },
        init: {
            'FilesAdded': function (up, files) {},
            'BeforeUpload': function (up, file) {},
            'UploadProgress': function (up, file) {},
            'UploadComplete': function () {},
            'FileUploaded': function (up, file, info) {
                var domain = up.getOption('domain');
                var res = $.parseJSON(info);
                // 获取上传成功后的文件的Url
                var sourceLink = domain + res.key;
                $('#avatar-file').val(sourceLink);
                avatarUploader.stop();
                avatarUploader.removeFile(file);
            },
            'Error': function (up, err, errTip) {
                //上传出错时，处理相关的事情
                new PNotify({
                    title: '提示',
                    text: "文件上传出错"
                });
                avatarUploader.stop();
                avatarUploader.removeFile(err.file);
            },
        }
    });

    // 空间背景
    var bgUploader = Qiniu.uploader({
        runtimes: 'html5,flash,html4', // 上传模式，依次退化
        browse_button: 'bg-file-btn', // 上传选择的点选按钮，必需
        uptoken_url: '/admin/upload/uptoken', // Ajax请求uptoken的Url
        get_new_uptoken: false, // 设置上传文件的时候是否每次都重新获取新的uptoken
        domain: 'http://botfile.imgondar.com', // bucket域名，下载资源时用到，必需
        max_file_size: '100mb', // 最大文件体积限制
        flash_swf_url: '/static/plupload/Moxie.swf', //引入flash，相对路径
        max_retries: 3, // 上传失败最大重试次数
        dragdrop: true, // 开启可拖曳上传
        drop_element: 'chating-text', // 拖曳上传区域元素的ID，拖曳文件或文件夹后可触发上传
        chunk_size: '4mb', // 分块上传时，每块的体积
        auto_start: true, // 选择文件后自动上传，若关闭需要自己绑定事件触发上传
        multi_selection: false,
        unique_names: true,
        filters: {
            mime_types: [{
                    title: "Image files",
                    extensions: "jpg,gif,png,jpeg"
                } // 限定jpg,gif,png后缀上传
            ]
        },
        init: {
            'FilesAdded': function (up, files) {},
            'BeforeUpload': function (up, file) {},
            'UploadProgress': function (up, file) {},
            'UploadComplete': function () {},
            'FileUploaded': function (up, file, info) {
                var domain = up.getOption('domain');
                var res = $.parseJSON(info);
                // 获取上传成功后的文件的Url
                var sourceLink = domain + res.key;
                $('#bg-file').val(sourceLink);
                bgUploader.stop();
                bgUploader.removeFile(file);
            },
            'Error': function (up, err, errTip) {
                //上传出错时，处理相关的事情
                new PNotify({
                    title: '提示',
                    text: "文件上传出错"
                });
                bgUploader.stop();
                bgUploader.removeFile(err.file);
            },
        }
    });
});

/**
 * 显示空间二维码
 * @param  {[type]}   img      [description]
 * @param  {[type]}   oid      [description]
 * @param  {Function} callback [description]
 * @return {[type]}            [description]
 */
function showQRDialog(img, oid, callback) {
    _this = $('#space-qr-modal');
    _this.modal('toggle');
    _this.find("#qr-img").attr('src', img);
    _this.find(".btn-reset-qrcode").attr('oid', oid).unbind('click').bind('click', function (event) {
        event.preventDefault();
        _this.modal('hide');
        var _that = $(this);
        var $btn = _that.button('loading');
        resetQrcode(oid, function () {
            $btn.button('reset');
        });
    });
    _this.find(".btn-sure").on('click', function (event) {
        typeof callback == "function" && callback();
        _this.modal('hide');
    });
}

/**
 * 获取机器人的群
 * @param  {[type]} robot_id [description]
 * @return {[type]}          [description]
 */
function getGroups(robot_id, callback) {
    $.ajax({
            url: '/admin/Space/groups',
            type: 'POST',
            dataType: 'json',
            data: {
                robot_id: robot_id
            },
            cache: false
        })
        .done(function (res) {
            var res = JSON.parse(res);
            if (res.error) {
                new PNotify({
                    title: '提示',
                    text: res.msg,
                    'type': 'error'
                });
            } else {
                var html = template('groups-tmp', res.data);
                document.getElementById('qun_nickname').innerHTML = html;
            }
        })
        .fail(function () {
            new PNotify({
                title: '提示',
                text: '网络请求失败',
                'type': 'error'
            });
        })
        .always(function () {
            typeof callback == "function" && callback();
        });
}

/**
 * 重置二维码
 * @param {*} oid 
 * @param {*} callback 
 */
function resetQrcode(oid, callback) {
    $.ajax({
            url: "/admin/Space/resetQrcode",
            type: 'POST',
            dataType: 'json',
            data: {
                id: oid
            },
            cache: false
        })
        .done(function () {
            window.location.reload();
        })
        .fail(function () {
            new PNotify({
                title: '提示',
                text: '网络请求失败',
                'type': 'error'
            });
        })
        .always(function () {
            typeof callback == "function" && callback();
        });
}

/**
 * 添加用户
 * @param {*} oid 
 * @param {*} nickname 
 * @param {*} callback 
 */
function addUser(oid, nickname, callback) {
    $.ajax({
            url: "/admin/Space/addUser",
            type: 'POST',
            dataType: 'json',
            data: {
                oid: oid,
                nickname: nickname
            },
            cache: false,
        })
        .done(function (res) {
            var res = JSON.parse(res);
            if (res.error) {
                new PNotify({
                    title: '提示',
                    text: res.msg
                });
            } else {
                window.location.reload();
            }
        })
        .fail(function (res) {
            new PNotify({
                title: '提示',
                text: '网络请求失败'
            });
        })
        .always(function () {
            typeof callback == "function" && callback();
        });
}

/**
 * 删除用户
 * @param {*} oid 
 * @param {*} callback 
 */
function deleteUser(oid, callback) {
    $.ajax({
            url: "/admin/Space/deleteUser",
            type: 'POST',
            dataType: 'json',
            data: {
                id: oid
            },
            cache: false,
        })
        .done(function (res) {
            var res = JSON.parse(res);
            if (res.error) {
                new PNotify({
                    title: '提示',
                    text: res.msg
                });
            } else {
                window.location.reload();
            }
        })
        .fail(function (res) {
            new PNotify({
                title: '提示',
                text: '网络请求失败'
            });
        })
        .always(function () {
            typeof callback == "function" && callback();
        });
}