$(function () {
    //获取所有群
    var robot_id = $('#robot').val();
    if (robot_id && robot_id != 0) {
        getGroups(robot_id,0);
    }

    $('#robot').unbind('change').bind('change', function (event) {
        event.preventDefault();
        var _this = $(this);
        var robot_id = _this.val();
        if (robot_id && robot_id != 0) {
            getGroups(robot_id);
        } else {
            $('#groups').addClass('hidden');
        }
    });

    // 添加业务群
    $('#btn-create').unbind('click').bind('click', function () {
        event.preventDefault();
        var _this = $(this);
        var url = "/admin/Businessgroup/addgroup";
        var _modal = $('#create-modal').modal('show');

        _modal.find("#uploadForm")[0].reset();
        _modal.find("#keyword").removeAttr("disabled");
        _modal.find("#group").removeAttr("disabled");
        _modal.find("#robot").removeAttr("disabled");
        _modal.find("#status").css("display","none");
        _modal.find('#groups').addClass('hidden');

        _modal.find('.btn-save').unbind('click').bind('click', function () {
            var _that = $(this);
            var keyword = $.trim(_modal.find('#keyword').val());
            var group = $.trim(_modal.find('#group').val());
            var qrcode = _modal.find('#img_file_url').val();
            if (keyword == '' || group == '' || qrcode == '') {
                new PNotify({
                    title: '提示',
                    text: '请填写必要信息'
                });
                return;
            };
            var $btn = _that.button('loading');
            var formData = new FormData($("#uploadForm")[0]);
            $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    cache: false,
                    async: false,   
                    contentType: false,  
                    processData: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function (res) {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                })
                .always(function () {
                    _modal.modal('hide');
                    $btn.button('reset');
                });
        });
    });

    // 修改
    $(".btn-update").click(function(){
        event.preventDefault();
        var _this = $(this);

        var _modal = $('#create-modal').modal('show');

        // 填充数据
        var oid = _this.attr("oid");
        var config = $.parseJSON( $("#td_c_"+oid).text() );

        _modal.find("#keyword").val(config.group_key); 
        _modal.find("#robot").val(config.robot_id); 
        getGroups(config.robot_id,config.group_id);
        _modal.find("#img_file_url").val(config.group_qrcode); 

        _modal.find("#status").css("display","block");

        var status = config.status;
        if (parseInt(status)==1) {
            // 开始中
            _modal.find("input[name='status']").eq(0).attr("checked",true);
        }else if(parseInt(status)==2){
            // 进行中
            _modal.find("input[name='status']").eq(1).attr("checked",true);
        }else if(parseInt(status)==3){
            // 已结束
            _modal.find("input[name='status']").eq(2).attr("checked",true);
        }
        _modal.find("#media_id").val(config.media_id);

        // _modal.find("#keyword").attr("disabled", "disabled");
        // _modal.find("#group").attr("disabled", "disabled");
        // _modal.find("#robot").attr("disabled", "disabled");
        
        // 点击保存按钮
        _modal.find('.btn-save').unbind('click').bind('click', function () {
            var _that = $(this);
            var url = "/admin/Businessgroup/updategroup/oid/"+oid;
            var $btn = _that.button('loading');
            var formData = new FormData($("#uploadForm")[0]);
            $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    cache: false,
                    async: false,   
                    contentType: false,  
                    processData: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function (res) {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                })
                .always(function () {
                    _modal.modal('hide');
                    $btn.button('reset');
                });
        });
    });


    // 删除业务群
    $('.btn-delete').unbind('click').bind('click', function (event) {
        var url = "/admin/Businessgroup/deletegroup";
        var oid = $(this).attr('oid');
        showDialog("删除业务群", "确定删除业务群？", function () {
            $.ajax({
                    url: url + "?id=" + oid,
                    type: 'GET',
                    dataType: 'json',
                    data: {},
                    cache: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function () {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                });
        });
    });

    //上传图片
    var imgUploader = Qiniu.uploader({
        runtimes: 'html5,flash,html4',          // 上传模式，依次退化
        browse_button: 'img-file-btn',                // 上传选择的点选按钮，必需
        uptoken_url: '/admin/upload/uptoken',   // Ajax请求uptoken的Url
        get_new_uptoken: true,                 // 设置上传文件的时候是否每次都重新获取新的uptoken
        domain: 'http://botfile.imgondar.com/',              // bucket域名，下载资源时用到，必需
        max_file_size: '100mb',             // 最大文件体积限制
        flash_swf_url: '/static/plupload/Moxie.swf',  //引入flash，相对路径
        max_retries: 3,                     // 上传失败最大重试次数
        dragdrop: true,                     // 开启可拖曳上传
        drop_element: 'chating-text',       // 拖曳上传区域元素的ID，拖曳文件或文件夹后可触发上传
        chunk_size: '4mb',                  // 分块上传时，每块的体积
        auto_start: true,                   // 选择文件后自动上传，若关闭需要自己绑定事件触发上传
        multi_selection: false,
        unique_names: true,
        filters : {
            mime_types: [
                {title : "Image files", extensions : "jpg, gif,png,jpeg"} // 限定jpg,gif,png后缀上传      
            ]
        },
        init: {
            'FilesAdded': function(up, files) {
            },
            'BeforeUpload': function(up, file) {
            },
            'UploadProgress': function(up, file) {
                showLoading();
            },
            'UploadComplete': function() {
            },
            'FileUploaded': function(up, file, info) {
                var domain = up.getOption('domain');
                var res = $.parseJSON(info);
                // 获取上传成功后的文件的Url
                var sourceLink = domain + res.key;
                console.log(sourceLink);
                $('#img_file_url').val(sourceLink);

                imgUploader.stop();
                imgUploader.removeFile(file);
                hideLoading();
            },
            'Error': function(up, err, errTip) {
                //上传出错时，处理相关的事情
                new PNotify({title: '提示', text: "文件上传出错"});
                imgUploader.stop();
                imgUploader.removeFile(err.file);
                hideLoading();
            },
        }
    });
});

/**
 * 获取机器人的群
 * @param  {[type]} robot_id [description]
 * @return {[type]}          [description]
 */
function getGroups(robot_id,group_id) {
    $.ajax({
            url: '/admin/Group/groups',
            type: 'POST',
            dataType: 'json',
            data: {
                robot_id: robot_id
            },
            cache: false
        })
        .done(function (res) {
            var res = JSON.parse(res);
            if (res.error) {
                new PNotify({
                    title: '提示',
                    text: res.msg,
                    'type': 'error'
                });
            } else {
                $('#groups').removeClass('hidden');
                var request = getRequest(window.location.search);
                res.data['c_g'] = request['g'];
                console.log(res.data);
                var html = template('groups-tmp', res.data);
                document.getElementById('group').innerHTML = html;
                if (group_id!=0) {
                    $('#group').val(group_id);
                }
            }
        })
        .fail(function () {
            new PNotify({
                title: '提示',
                text: '网络请求失败',
                'type': 'error'
            });
        })
        .always(function () {});
}