<?php

use think\Loader;

Loader::import('requests/library/Requests', EXTEND_PATH);
Loader::import('phpqrcode/phpqrcode', EXTEND_PATH);

\Requests::register_autoloader();

if (!function_exists('qrcode')) {
    function qrcode($url, $filename, $level = 3, $size = 4)
    {
        $path = APP_PATH.'../public/qrcode/';
        //容错级别  
        $errorCorrectionLevel = intval($level);
        //生成图片大小  
        $matrixPointSize = intval($size);
        //生成二维码图片
        $object = new \QRcode();
        //第二个参数false的意思是不生成图片文件，
        //如果你写上picture.png则会在根目录下生成一个png格式的图片文件
        $object->png($url, $path.$filename, $errorCorrectionLevel, $matrixPointSize, 2);

        return $filename;
    }
}

if (!function_exists('requests_post')) {
    function requests_post($url='', $token=false, $params = array())
    {
        $url = config('default.api_url').$url;
        $headers = array('Content-Type' => 'application/json');
        if ($token) {
            $headers['Token'] = $token;
        }
        $request = \Requests::post($url, $headers, json_encode($params));
        $response = json_decode($request->body, true);
        return $response;
    }
}

/* 将链接转换为新浪短网值 */
if (!function_exists('short_url')) {
    function short_url($url_long)
    {
        $url = "http://api.t.sina.com.cn/short_url/shorten.json?source=3301416192";
        if (is_array($url_long)) {
            $params = "";
            foreach ($url_longs as $url_long) {
                $params .= "&url_long=".urlencode($url_long);
            }
            $url = $url.$params;
        }else{
            $url .= "&url_long=".urlencode($url_long);
        }
        $request = \Requests::get($url);
        $response = json_decode($request->body);
        return $response;
    }
}

if (!function_exists('http_get')) {
    function http_get($url='')
    {
        $response = \Requests::get($url)->body;
        $response = json_decode($response);
        return $response;
    }
}

/* 把文本中所有的链接地址替换成新浪短网值 */
if (!function_exists('replace_urls2short')) {
    function replace_urls2short($text)
    {
        $regex='/((http:\/\/|www\.|https:\/\/)(\w+|\.|\?|\=|\/|\&|\:|\d+)+)/';
        $data = preg_replace_callback($regex, function($matches){
            if(!empty($matches[0]) && (strstr($matches[0], 'http://') || strstr($matches[0],'https://'))){
                $short_urls = short_url( $matches[0] );
                if (is_array($short_urls)) {
                    return $short_urls[0]->url_short;
                }
                return $matches[0];
            }else{
                // 匹配到可能是：www.xxx.com
                $matches[0] = "http://".$matches[0];
                $short_urls = short_url( $matches[0] );
                if (is_array($short_urls)) {
                    return $short_urls[0]->url_short;
                }
                return $matches[0];
            }
        }, $text);

        return $data;
    }
}

/**
 * 获取远程文件的大小，单位为；KB
 * @param (string)url  远程文件地址，如图片，视频或文件，可以是短链接
 * @return (int) file_size  文件大小，单位为kb
*/
if (!function_exists('get_remote_filesize')) {
    function get_remote_filesize($url){
        $header_array = get_headers($url, true);
        $size = $header_array['Content-Length'];

        $size_kb = '';
        if (is_array($size)) {
            $size_kb = ceil( $size[count($size)-1] / 1000.0 );
        }else{
            $size_kb = ceil( $size / 1000.0 );
        }
        return $size_kb;
    }
}


/**
 * 友好的时间显示
 *
 * @param int    $sTime 待显示的时间
 * @param string $type  类型. normal | mohu | full | ymd | other
 * @return string
*/
if (!function_exists('friendlyTime')) {
    function friendlyTime($sTime, $type = 'normal') {
        if (!$sTime)
            return '';
        //sTime=源时间，cTime=当前时间，dTime=时间差
        $sTime = strtotime($sTime);
        $cTime      =   time();
        $dTime      =   $cTime - $sTime;
        $dDay       =   intval(date("z",$cTime)) - intval(date("z",$sTime));
        //$dDay     =   intval($dTime/3600/24);
        $dYear      =   intval(date("Y",$cTime)) - intval(date("Y",$sTime));
        //normal：n秒前，n分钟前，n小时前，日期
        if($type=='normal'){
            if( $dTime < 60 ){
                if($dTime < 10){
                    return '刚刚';    //by yangjs
                }else{
                    return intval(floor($dTime / 10) * 10)."秒前";
                }
            }elseif( $dTime < 3600 ){
                return intval($dTime/60)."分钟前";
            //今天的数据.年份相同.日期相同.
            }elseif( $dYear==0 && $dDay == 0  ){
                //return intval($dTime/3600)."小时前";
                return '今天'.date('H:i',$sTime);
            }elseif($dYear==0){
                return date("m月d日 H:i",$sTime);
            }else{
                return date("Y-m-d H:i",$sTime);
            }
        }elseif($type=='mohu'){
            if( $dTime < 60 ){
                return $dTime."秒前";
            }elseif( $dTime < 3600 ){
                return intval($dTime/60)."分钟前";
            }elseif( $dTime >= 3600 && $dDay == 0  ){
                return intval($dTime/3600)."小时前";
            }elseif( $dDay > 0 && $dDay<=7 ){
                return intval($dDay)."天前";
            }elseif( $dDay > 7 &&  $dDay <= 30 ){
                return intval($dDay/7) . '周前';
            }elseif( $dDay > 30 ){
                return intval($dDay/30) . '个月前';
            }
        //full: Y-m-d , H:i:s
        }elseif($type=='full'){
            return date("Y-m-d , H:i:s",$sTime);
        }elseif($type=='ymd'){
            return date("Y-m-d",$sTime);
        }else{
            if( $dTime < 60 ){
                return $dTime."秒前";
            }elseif( $dTime < 3600 ){
                return intval($dTime/60)."分钟前";
            }elseif( $dTime >= 3600 && $dDay == 0  ){
                return intval($dTime/3600)."小时前";
            }elseif($dYear==0){
                return date("Y-m-d H:i:s",$sTime);
            }else{
                return date("Y-m-d H:i:s",$sTime);
            }
        }
    }
}