<?php

namespace app\common\utils;

// 引入鉴权类
use Qiniu\Auth;
// 引入上传类
use Qiniu\Storage\UploadManager;
use app\common\utils\HttpHelper;

class QiniuHelper{

    private static $_instance;
    
    var $auth;
    var $bucket;
    var $domain;
    var $token;
    var $uploadMgr;
    
    private function __construct(){
      $accessKey = config("qiniu.accessKey");
      $secretKey = config("qiniu.secretKey");

      $this->auth = new Auth($accessKey, $secretKey);
      $this->bucket = config("qiniu.bucket");
      $this->domain = config("qiniu.domain");
      // 生成上传 Token
      $this->token = $this->auth->uploadToken($this->bucket);
      // 初始化 UploadManager 对象并进行文件的上传。
      $this->uploadMgr = new UploadManager();
    }

    // getInstance()方法必须设置为公有的,必须调用此方法
    public static function getInstance(){
        if (self::$_instance===null) {  
            self::$_instance = new self();  //方式二
        }
        return self::$_instance;
    }
    
    public function uploadFile($filePath, $img_key, $uploaded_delete=false){
        // 调用 UploadManager 的 putFile 方法进行文件的上传。
        list($ret, $err) = $this->uploadMgr->putFile($this->token, $img_key, $filePath);
        // echo "\n====> putFile result: \n";
        if ($err !== null) {
            return false;
        } else {
            if ($uploaded_delete) {
                // 上传后删除
                unlink($filePath);
            }
            return $this->domain.$ret['key'];
        }
    }
    
    /**
     * 七牛云@图片鉴黄
     * @param (string)url  七牛云图片地址
     * @return Array ( [label] => 1 [review] => [score] => 0.9992174 )
     * label：0-色情；1-性感；2-正常；
     * score：介于0-1间的浮点数，表示该图像被识别为某个分类的概率值，概率越高、机器越肯定；
     * review： 是否需要人工复审该图片，鉴黄服务是否对结果确定。true需要false不需要，如果请求失败，请查看和message字段的返回说明。
    */
    public static function checkPornImage($url){
        $url = $url."?qpulp";
        $res = false;
        try {
          $res = file_get_contents($url);
        } catch (\Exception $e) {
          return false;
        }
        if (!$res) {
          return false;
        }
        $res = json_decode($res, true);
        if (isset($res['error'])) {
          return false;
        }
        if (isset($res['code']) && $res['code']==0) {
          // $res['result'] ===> Array ( [label] => 1 [review] => [score] => 0.9992174 )
          $result = $res['result'];
          // 色情图片
          if ($result['label']==0) {
            return true;
          }
          // 性感图片，概率大于0.5
          if ($result['label']==1 && $result['score']>0.5) {
            return true;
          }
          // 其他：正常或概率低于0.5的性感图片
          return false;
        }
        return false;
    }

}