<?php
/**
 * Created by PhpStorm.
 * User: Administrator
 * Date: 2018/9/19
 * Time: 14:56
 */

namespace app\common\model;


use traits\model\SoftDelete;

class User extends BaseModel
{
    use SoftDelete;

    // 设置当前模型对应的完整数据表名称
    protected $table = 'mr_users';

    //根据过期时间判断VIP是否过期
    public function getIsVipAttr($value,$data)
    {
        $current_time = time();
        if(!empty($data['vip_endtime']) && $current_time<strtotime($data['vip_endtime'])){
            //会员
            return 1;
        }else{
            return 0;
        }
    }

    //用户收藏多对多
    public function project()
    {
        return $this->belongsToMany('Project','user_collections','pid','uid');
    }


}