<?php
/**
 * Created by PhpStorm.
 * User: 30868
 * Date: 2018/9/13
 * Time: 23:24
 */

namespace app\common\model;

use traits\model\SoftDelete;
use app\common\model\Tags as TagsModel;
use app\common\model\Citys as CitydModel;
use app\common\model\Catalogs as CatalogModel;


class Project extends BaseModel
{
    use SoftDelete;

    // 设置当前模型对应的完整数据表名称
    protected $table = 'mr_projects';

    //标签处理
    public function getTagsAttr($value)
    {
        $value = trim($value,'|');
        $tags = explode('|', $value);
        $tags = TagsModel::where('id', 'in', $tags)
            ->order('sort', 'desc')
            ->column('name');
        return implode(' / ',$tags);
    }

    //活动时间标签
    public function getSignEndtimeStrAttr($value, $data)
    {
        $endTime = strtotime($data['sign_endtime']);
        if ($data['type'] == 1) {
            //活动
            if ($endTime > time()) {
                //未结束
                return '剩余'.ceil(($endTime-time())/86400).'天';
            } else {
                return '结束,预约下一次';
            }
        } elseif ($data['type'] == 2) {
            //商家
            return '商家';
        }
    }

    //城市名称处理
    public function getCityStrAttr($value,$data){
      $city_id = $data['city'];
      return CitydModel::get($city_id);
    }

    //分类名称处理
    public function getCatalogIdStrAttr($value,$data){
        $catalog_id = $data['catalog_id'];
        return CatalogModel::get($catalog_id);
    }
    //需要用到tags ID
    public function getTagsIdStrAttr($value,$data){
        return $data['tags'];
    }

    public function getBannersAttr($value)
    {
        $data = json_decode($value,true);
        $banners = [];
        foreach($data as $k =>$v){
            $banners[] = ['image'=>$v];
        }
        return $banners;
    }
//    需要用到banners字段的原始格式
    public function getBannersNativeAttr($value,$data){
        return $data['banners'];
    }
}
