<?php

namespace app\common\model;

use think\Model;
use traits\model\SoftDelete;

class Post extends Model
{
    use SoftDelete;

    // 设置当前模型对应的完整数据表名称
    protected $table = 'mr_guides';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = 'datetime';

    // 定义时间戳字段名
    protected $createTime = 'created_at';
    protected $updateTime = 'updated_at';

    protected $deleteTime = 'deleted_time';

    public function admin()
    {
    	return $this->hasOne('Admin', 'id', 'admin_id');
    }
}
