<?php

namespace app\common\model;

use think\Model;
use traits\model\SoftDelete;

class Phonecaptcha extends Model
{
    use SoftDelete;

    // 设置当前模型对应的完整数据表名称
    protected $table = 'mr_phonecaptcha';

    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = 'datetime';

    // 定义时间戳字段名
    protected $createTime = 'created_at';
    protected $updateTime = 'updated_at';

    protected $deleteTime = 'deleted_time';

    /**
     * 验证码是否过期
     */
    public function is_expires(){
		$now = time();
		//超过10分钟
		if ( $now - strtotime($this->updated_at) > $this->expires_in ) {
			return true;
		}else{
			return false;
		}
	}
}
