<?php

namespace app\common\model;

use think\Model;
use traits\model\SoftDelete;
use \think\Session;

class Log extends Model
{
    use SoftDelete;
    
    // 设置当前模型对应的完整数据表名称
    protected $table = 'mr_logs';
    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = 'datetime';
    
    // 定义时间戳字段名
    protected $createTime = 'created_at';
    protected $updateTime = 'updated_at';
    
    protected $deleteTime = 'deleted_time';
    protected $insert     = ['ip', 'user_id', 'browser', 'os'];

    public function admin()
    {
        return $this->belongsTo('Admin', 'user_id');
    }

    // 获取分类
    public function getLevelTextAttr($value, $data)
    {
        $status = ['info'=>'信息', 'debug'=>'调试', 'error'=>'错误异常'];
        return $status[$data['level']];
    }

    /**
     * 记录ip地址
     */
    protected function setIpAttr()
    {
        return \app\common\tools\Visitor::getIP();
    }

    protected function getIpAttr()
    {
        return \app\common\tools\Visitor::getIP();
    }

    /**
     * 浏览器把版本
     */
    protected function setBrowserAttr()
    {
        return \app\common\tools\Visitor::getBrowser().'-'.\app\common\tools\Visitor::getBrowserVer();
    }
    protected function getBrowserAttr()
    {
        return \app\common\tools\Visitor::getBrowser().'-'.\app\common\tools\Visitor::getBrowserVer();
    }

    /**
     * 系统类型
     */
    protected function setOsAttr()
    {
        return \app\common\tools\Visitor::getOs();
    }

    protected function getOsAttr()
    {
        return \app\common\tools\Visitor::getOs();
    }

    /**
     * 用户id
     */
    protected function setUserIdAttr()
    {
        $user_id = 0;
        if (Session::has('uid') !== false) {
            $user_id = Session::get('uid');
        }
        return $user_id;
    }

    protected function getUserIdAttr()
    {
        $user_id = 0;
        if (Session::has('uid') !== false) {
            $user_id = Session::get('uid');
        }
        return $user_id;
    }
    
    /**
     * 记录日志
     * @param $level string 日志级别：info debug error
     * @param $category string  日志自定义分类，类似标签
     * @param $message string  日志内容
     */
    public function record($level, $category, $message)
    {
        $this->insert(['level'=>$level, 'category'=>$category, 'message' => $message, 'ip'=>$this->ip, 'os'=>$this->os, 'browser'=>$this->browser, 'user_id'=>$this->user_id]);
    }

    /**
     * 记录日志
     * @param $category string  日志自定义分类，类似标签
     * @param $message string  日志内容
     */
    public function info($category, $message)
    {
        $this->record('info', $category, $message);
    }

    /**
     * 记录日志
     * @param $category string  日志自定义分类，类似标签
     * @param $message string  日志内容
     */
    public function debug($category, $message)
    {
        $this->record('debug', $category, $message);
    }

    
    /**
     * 记录日志
     * @param $category string  日志自定义分类，类似标签
     * @param $message string  日志内容
     */
    public function error($category, $message)
    {
        $this->record('error', $category, $message);
    }

    public function UniqueIpCount()
    {   
        $data = $this->column('ip');
        $data = count( array_unique($data) );
        return $data;
    }

}
