<?php

namespace app\admin\controller;

use app\admin\controller\AuthBase;
use app\common\model\Log as LogModel;
use app\common\model\Admin as AdminModel;

class Log extends AuthBase
{
	/**
     * 显示资源列表
     *
     * @return \think\Response
     */
    public function index()
    {
    	$level = input('level');
        $category = input('category');
        $admin = input('admin');

        $map = [];
        if ($admin) {
        	$uids = AdminModel::where('username','like','%'.$admin.'%')
        		->field('id')
			    ->select();
			if ($uids) {
				$in_uids = [];
				foreach ($uids as $key => $value) {
					$in_uids = $value['id'];
				}
				$map['user_id'] = ['in', $in_uids];
			}
        }
        if ($level != null) {
        	$map['level'] = $level;
        }
        if ($category != null) {
        	$map['category'] = ['like', "%$category%"];
        }
        $items = LogModel::where($map)
        	->with('admin')
            ->order('id', 'desc')
            ->paginate(15, false)
            ->each(function($item, $key){
                // 拼接字符串
            	$item['visitor'] = 'IP：'.$item['ip'].'<br/>'.'OS：'.$item['os'].'<br/>'.'Browser：'.$item['browser'];
            });

        $this->assign('items', $items);

    	return view();
    }
}