$(function(){
    //上传图片
    var imgUploader = Qiniu.uploader({
        runtimes: 'html5,flash,html4',          // 上传模式，依次退化
        browse_button: 'img-file-btn',                // 上传选择的点选按钮，必需
        uptoken_url: '/admin/upload/uptoken',   // Ajax请求uptoken的Url
        get_new_uptoken: true,                 // 设置上传文件的时候是否每次都重新获取新的uptoken
        domain: 'http://botfile.imgondar.com/',              // bucket域名，下载资源时用到，必需
        max_file_size: '100mb',             // 最大文件体积限制
        flash_swf_url: '/static/plupload/Moxie.swf',  //引入flash，相对路径
        max_retries: 3,                     // 上传失败最大重试次数
        dragdrop: true,                     // 开启可拖曳上传
        drop_element: 'chating-text',       // 拖曳上传区域元素的ID，拖曳文件或文件夹后可触发上传
        chunk_size: '4mb',                  // 分块上传时，每块的体积
        auto_start: true,                   // 选择文件后自动上传，若关闭需要自己绑定事件触发上传
        multi_selection: false,
        unique_names: true,
        filters : {
            mime_types: [
                {title : "Image files", extensions : "jpg, gif,png,jpeg"} // 限定jpg,gif,png后缀上传      
            ]
        },
        init: {
            'FilesAdded': function(up, files) {
            },
            'BeforeUpload': function(up, file) {
            },
            'UploadProgress': function(up, file) {
                showLoading();
            },
            'UploadComplete': function() {
            },
            'FileUploaded': function(up, file, info) {
                var domain = up.getOption('domain');
                var res = $.parseJSON(info);
                // 获取上传成功后的文件的Url
                var sourceLink = domain + res.key;
                $('#img_file_url').val(sourceLink);

                imgUploader.stop();
                imgUploader.removeFile(file);
                hideLoading();
            },
            'Error': function(up, err, errTip) {
                //上传出错时，处理相关的事情
                new PNotify({title: '提示', text: "文件上传出错"});
                imgUploader.stop();
                imgUploader.removeFile(err.file);
                hideLoading();
            },
        }
    });

    //上传视频
    var videoUploader = Qiniu.uploader({
        runtimes: 'html5,flash,html4',          // 上传模式，依次退化
        browse_button: 'video-file-btn',                // 上传选择的点选按钮，必需
        uptoken_url: '/admin/upload/uptoken',   // Ajax请求uptoken的Url
        get_new_uptoken: true,                 // 设置上传文件的时候是否每次都重新获取新的uptoken
        domain: 'http://botfile.imgondar.com/',              // bucket域名，下载资源时用到，必需
        max_file_size: '100mb',             // 最大文件体积限制
        flash_swf_url: '/static/plupload/Moxie.swf',  //引入flash，相对路径
        max_retries: 3,                     // 上传失败最大重试次数
        dragdrop: true,                     // 开启可拖曳上传
        drop_element: 'chating-text',       // 拖曳上传区域元素的ID，拖曳文件或文件夹后可触发上传
        chunk_size: '4mb',                  // 分块上传时，每块的体积
        auto_start: true,                   // 选择文件后自动上传，若关闭需要自己绑定事件触发上传
        multi_selection: false,
        unique_names: true,
        filters : {
            mime_types: [
                {title : "Video files", extensions : "flv,mpg,mpeg,avi,wmv,mov,asf,rm,rmvb,mkv,m4v,mp4"}, // 限定flv,mpg,mpeg,avi,wmv,mov,asf,rm,rmvb,mkv,m4v,mp4后缀格式上传    
            ]
        },
        init: {
            'FilesAdded': function(up, files) {
            },
            'BeforeUpload': function(up, file) {
            },
            'UploadProgress': function(up, file) {
                showLoading();
            },
            'UploadComplete': function() {
            },
            'FileUploaded': function(up, file, info) {
                var domain = up.getOption('domain');
                var res = $.parseJSON(info);
                // 获取上传成功后的文件的Url
                var sourceLink = domain + res.key;
                $('#video_file_url').val(sourceLink);

                videoUploader.stop();
                videoUploader.removeFile(file);
                hideLoading();
            },
            'Error': function(up, err, errTip) {
                //上传出错时，处理相关的事情
                new PNotify({title: '提示', text: "文件上传出错"});
                hideLoading();
                videoUploader.stop();
                videoUploader.removeFile(err.file);
            },
        }
    });

     //上传文件
    var Uploader = Qiniu.uploader({
        runtimes: 'html5,flash,html4',          // 上传模式，依次退化
        browse_button: 'file-btn',                // 上传选择的点选按钮，必需
        uptoken_url: '/admin/upload/uptoken',   // Ajax请求uptoken的Url
        get_new_uptoken: true,                 // 设置上传文件的时候是否每次都重新获取新的uptoken
        domain: 'http://botfile.imgondar.com/',              // bucket域名，下载资源时用到，必需
        max_file_size: '100mb',             // 最大文件体积限制
        flash_swf_url: '/static/plupload/Moxie.swf',  //引入flash，相对路径
        max_retries: 3,                     // 上传失败最大重试次数
        dragdrop: true,                     // 开启可拖曳上传
        drop_element: 'chating-text',       // 拖曳上传区域元素的ID，拖曳文件或文件夹后可触发上传
        chunk_size: '4mb',                  // 分块上传时，每块的体积
        auto_start: true,                   // 选择文件后自动上传，若关闭需要自己绑定事件触发上传
        multi_selection: false,
        unique_names: true,
        init: {
            'FilesAdded': function(up, files) {
            },
            'BeforeUpload': function(up, file) {
            },
            'UploadProgress': function(up, file) {
                showLoading();
            },
            'UploadComplete': function() {
            },
            'FileUploaded': function(up, file, info) {
                var domain = up.getOption('domain');
                var res = $.parseJSON(info);
                // 获取上传成功后的文件的Url
                var sourceLink = domain + res.key;
                $('#file_url').val(sourceLink);

                Uploader.stop();
                Uploader.removeFile(file);
                hideLoading();
            },
            'Error': function(up, err, errTip) {
                //上传出错时，处理相关的事情
                new PNotify({title: '提示', text: "文件上传出错"});
                Uploader.stop();
                Uploader.removeFile(err.file);
                hideLoading();
            },
        }
    });

     // 添加关键词
    $('.btn-create-keyword').unbind('click').bind('click', function () {
        event.preventDefault();
        var _this = $(this);
        var from = _this.attr("from");
        var robot_id = 0;
        var oid = 0;
        var tag_id = 0;
        if (from == "tag") {
            tag_id = _this.attr("tag");
        }else{
            robot_id = _this.attr("rid");
            oid = _this.attr("oid");
        }
        var url = "/admin/keyword/addkw";
        var _modal = $('#create-keyword-modal').modal('show');
        _modal.find('.btn-save').unbind('click').bind('click', function () {
            var _that = $(this);
            var keyword = $.trim(_modal.find('#keyword').val());
            var type = _modal.find('#type').val();
            var data = $.trim(_modal.find('#data').val());
            var is_like = $.trim(_modal.find('input[name=is_like]:checked').val());
            if (keyword == '' || data == '' && data_type == 1) {
                new PNotify({
                    title: '提示',
                    text: '请填写必要信息'
                });
                return;
            };
            var $btn = _that.button('loading');
            var formData = new FormData($("#uploadForm")[0]); 
            formData.append("from", from);
            if (from == "tag") {
                formData.append("tag", tag_id);
            }else{
                formData.append("oid", oid);
                formData.append("robot_id", robot_id);
            }
            $.ajax({
                url: url,
                type: 'POST',
                dataType: 'json',
                data: formData,
                cache: false,
                async: false,   
                contentType: false,  
                processData: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function (res) {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                })
                .always(function () {
                    _modal.modal('hide');
                    $btn.button('reset');
                });
        });
    });

    // 修改关键词
    $('.btn-update-kw').unbind('click').bind('click', function (event) {
        event.preventDefault();
        var _this = $(this);
        var oid = _this.attr('oid');
        var _modal = $('#create-keyword-modal').modal('show');

        var url = "/admin/Keyword/updatekw?id="+oid;

        var kw_str = $("#tr_"+oid).find("td").eq(1).text();
        _modal.find("#keyword").val(kw_str);
        var reply_str = $("#tr_"+oid).find("td").eq(4).text().trim();
        var type_id = $("#tr_"+oid).find("td:eq(2)").attr("type_id");

        if ( parseInt(type_id) == 1 ) {
            // 文字
            _modal.find("select#data_type").find("option:eq(0)").attr("selected",true);
            _modal.find("#data").val(reply_str);
            setType(1);
        }else if(parseInt(type_id) == 2){
            // 图片
            _modal.find("select#data_type").find("option:eq(1)").attr("selected",true);
            _modal.find("#img_file_url").val(reply_str);
            setType(2);
        }else if(parseInt(type_id) == 4){
            // 视频
            _modal.find("select#data_type").find("option:eq(3)").attr("selected",true);
            _modal.find("#video_file_url").val(reply_str);
            setType(4);
        }else if(parseInt(type_id) == 3){
            // 文件
            _modal.find("select#data_type").find("option:eq(2)").attr("selected",true);
            _modal.find("#file_url").val(reply_str);
            setType(3);
        }else if(parseInt(type_id) == 5){
            // 名片
            var strs=reply_str.split(" ");
            _modal.find("select#data_type").find("option:eq(4)").attr("selected", true);
            _modal.find("#nickname").val(strs[0]);
            _modal.find("#alias").val(strs[1]);
            setType(5);
        }

        var is_like = $("#tr_"+oid).find("td:eq(3)").attr("is_like");
        if (parseInt(is_like)==1) {
            // 否
            _modal.find("input[name='is_like']").eq(1).attr("checked",true);
        }else{
            // 是
            _modal.find("input[name='is_like']").eq(0).attr("checked",true);
        }

        var send_type = $("#tr_"+oid).find("td:eq(5)").attr("sendtype");
        if (parseInt(send_type)==1) {
            // 文件
            _modal.find("input[name='send_type']").eq(1).attr("checked",true);
        }else if(parseInt(send_type)==2){
            // 链接
            _modal.find("input[name='send_type']").eq(2).attr("checked",true);
        }else{
            // 默认
            _modal.find("input[name='send_type']").eq(0).attr("checked",true);
        }

        var chat_type = $("#tr_"+oid).find("td:eq(5)").attr("chat_type");
        if (chat_type=="私聊") {
            // 否
            _modal.find("select#type").find("option:eq(0)").attr("selected",true);
        }else{
            // 是
            _modal.find("select#type").find("option:eq(1)").attr("selected",true);
        }

        _modal.find('.btn-save').unbind('click').bind('click', function () {
            var _that = $(this);
            var keyword = $.trim(_modal.find('#keyword').val());
            var type = _modal.find('#type').val();
            var data = $.trim(_modal.find('#data').val());
            var is_like = $.trim(_modal.find('input[name=is_like]:checked').val());
            if (keyword == '' || data == '' && data_type == 1 ) {
                new PNotify({
                    title: '提示',
                    text: '请填写必要信息'
                });
                return;
            };
            var $btn = _that.button('loading');
             var formData = new FormData($("#uploadForm")[0]); 
            $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    cache: false,
                    async: false,   
                    contentType: false,  
                    processData: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function (res) {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                })
                .always(function () {
                    _modal.modal('hide');
                    $btn.button('reset');
                });
        });
    });

    // 删除关键词
    $('.btn-delete-keyword').unbind('click').bind('click', function (event) {
        var url = "/admin/Robot/deletekw";
        var oid = $(this).attr('oid');
        showDialog("删除关键词回复", "确定删除关键词回复？", function () {
            $.ajax({
                    url: url + "?id=" + oid,
                    type: 'GET',
                    dataType: 'json',
                    data: {},
                    cache: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function () {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                });
        });
    });
});
//设置类型
function setType(id){
    $('#file_upload').css("display", "none");
    $('#img_file_upload').css("display", "none");
    $('#text').css("display", "none");
    $('#card').css("display", "none");
    $('#send_type').css("display", "none");
    $('#video_file_upload').css("display", "none");
    if (id==1) {
        $('#text').css("display", "block");
    }else if(id==2){
        $('#img_file_upload').css("display", "block");
    }else if(id==3){
        $('#file_upload').css("display", "block");
        $('#send_type').css("display", "block");
    }else if(id==4){
        $('#video_file_upload').css("display", "block");
        $('#send_type').css("display", "block");
    }else if (id==5) {
        $('#card').css("display", "block");
    }
}

