$(function(){
	 // 添加关键词
    $('.btn-create-tag').unbind('click').bind('click', function () {
        event.preventDefault();
        var _this = $(this);
        var url = "/admin/keyword/addtag";
        var _modal = $('#create-modal').modal('show');
        _modal.find('.btn-save').unbind('click').bind('click', function () {
            var _that = $(this);
            var tag = $.trim(_modal.find('#tag').val());
            if (tag == '') {
                new PNotify({
                    title: '提示',
                    text: '请填写必要信息'
                });
                return;
            };
            var $btn = _that.button('loading');
            $.ajax({
	                url: url,
	                type: 'POST',
	                dataType: 'json',
	                data:{
		                tag: tag
		            },
	                cache: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function (res) {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                })
                .always(function () {
                    _modal.modal('hide');
                    $btn.button('reset');
                });
        });
    });

    // 修改标签
    $('.btn-update-tag').unbind('click').bind('click', function (event) {
        event.preventDefault();
        var _this = $(this);
        var oid = _this.attr('oid');
        var _modal = $('#create-modal').modal('show');

        var url = "/admin/keyword/updatetag?id="+oid;

        var tag_str = $("#tr_"+oid).find("td").eq(1).text();
        _modal.find("#tag").val(tag_str);
       
        _modal.find('.btn-save').unbind('click').bind('click', function () {
            var _that = $(this);
            var tag = $.trim(_modal.find('#tag').val());
            if (tag == '') {
                new PNotify({
                    title: '提示',
                    text: '请填写必要信息'
                });
                return;
            };
            var $btn = _that.button('loading');
            $.ajax({
                    url: url,
                    type: 'POST',
                    dataType: 'json',
                    data:{
		                tag: tag
		            },
	                cache: false,
                })
                .done(function (res) {
                    var res = JSON.parse(res);
                    if (res.error) {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                    } else {
                        window.location.reload();
                    }
                })
                .fail(function (res) {
                    new PNotify({
                        title: '提示',
                        text: '网络请求失败'
                    });
                })
                .always(function () {
                    _modal.modal('hide');
                    $btn.button('reset');
                });
        });
    });

    // 删除标签
    $(".btn-delete-tag").click(function(){
        var _this = $(this);
        var url = "deletetag";
        var oid = _this.attr('oid');
        showDialog("提示", "确定删除这条标签吗？", function () {
            // ajax post 方法
            $.post(url, {id:oid}, function (res) {
                var res = JSON.parse(res);
                if (res.error == 1) {
                    // javascript 的默认弹出提示方法
                    alert(res.msg);
                } else {
                    _this.remove();
                    $("#tr_"+oid).fadeOut();
                }
            });
        });
    });
});