$(function () {
    $('#robot').unbind('change').bind('change', function (event) {
        event.preventDefault();
        var _this = $(this);
        var robot_id = _this.val();
        if (robot_id && robot_id != 0) {
            getGroups(robot_id);
        } else {
            $('#groups').addClass('hidden');
        }
    });

    var fromoid = parseInt($("#btn-copy").attr("fromoid"));
    if(isNaN(fromoid) == false){
        var robot_id = $('#robot').val();
        getGroups(robot_id);
    }

    $('#is_group').unbind('change').bind('change', function (event) {
        event.preventDefault();
        var _this = $(this);
        var is_group = _this.val();
        var robot_id = $('#robot').val();
        if (robot_id && is_group && robot_id != 0 && is_group == 'group') {
            getGroups(robot_id);
        } else {
            $('#groups').addClass('hidden');
        }
    });

    // 复制到群
    $("#btn-copy").bind('click', function (event) {
        event.preventDefault();
        var _this = $(this);
        var url = "/admin/Group/copykw";
        var from_group_id = parseInt($(this).attr('fromoid'));
        if (isNaN(from_group_id)) {
            new PNotify({
                title: '提示',
                text: "请先选择机器人和群",
                'type': 'warning'
            });
            return;
        };
        var to_group_id = 0;
        var from_robot_id = parseInt($("#robot").val());

        var _modal = $('#copy-modal').modal('show');
        _modal.find("#robot-sel2").find("option:eq(0)").attr("selected", true);
        
        _modal.find("#robot-sel2").change(function(){
            var sel2_this = $(this);
            var robot_id = sel2_this.val();

            $.ajax({
                url: '/admin/Group/groups',
                type: 'POST',
                dataType: 'json',
                data: {
                    robot_id: robot_id
                },
                cache: false
            })
            .done(function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    _modal.find('#groups-sel2').removeClass('hidden');
                    res.data['c_g'] = 0;
                    var html = template('groups-tmp', res.data);
                    _modal.find('#group-sel2').html(html);
                }
            })
            .fail(function () {
                new PNotify({
                    title: '提示',
                    text: '网络请求失败',
                    'type': 'error'
                });
            })
            .always(function () {});

            _modal.find("#group-sel2").change(function(){
                to_group_id = parseInt( $(this).val() ); 
            });

            // 按钮
            _modal.find('.btn-save').unbind('click').bind('click', function () {
                if (from_group_id==0 || to_group_id==0 || from_robot_id==0 || (from_group_id==to_group_id) || isNaN(from_group_id) || isNaN(to_group_id) || isNaN(from_robot_id)) {
                    new PNotify({
                        title: '提示',
                        text: "选择错误！！！",
                        'type': 'error'
                    });
                    return;
                }

                var copy_params = {from_group_id:from_group_id, to_group_id:to_group_id, from_robot_id:from_robot_id};
                $.post(url, copy_params, function(res){
                    res = JSON.parse(res);
                    console.log(res);
                    if (res.error==1) {
                        new PNotify({
                            title: '提示',
                            text: res.msg,
                            'type': 'error'
                        });
                        _modal.modal('hide');
                    } else {
                        new PNotify({
                            title: '提示',
                            text: res.msg
                        });
                        window.location.href = "/admin/Group/reply?r="+res.r;
                    }
                });
            });

        });
    });
});

/**
 * 获取机器人的群
 * @param  {[type]} robot_id [description]
 * @return {[type]}          [description]
 */
function getGroups(robot_id) {
    $.ajax({
            url: '/admin/Group/groups',
            type: 'POST',
            dataType: 'json',
            data: {
                robot_id: robot_id
            },
            cache: false
        })
        .done(function (res) {
            var res = JSON.parse(res);
            if (res.error) {
                new PNotify({
                    title: '提示',
                    text: res.msg,
                    'type': 'error'
                });
            } else {
                $('#groups').removeClass('hidden');
                var request = getRequest(window.location.search);
                res.data['c_g'] = request['g'];
                var html = template('groups-tmp', res.data);
                document.getElementById('group').innerHTML = html;
            }
        })
        .fail(function () {
            new PNotify({
                title: '提示',
                text: '网络请求失败',
                'type': 'error'
            });
        })
        .always(function () {});
}



