<?php

namespace app\common\utils;

class RedisHelper{
    
    private static $_instance;
    public $redis;
    
    private function __construct(){
      $this->redis = new \Redis();
      $this->redis->pconnect(config("redis.hostname"), config("redis.port"));
      $conn = $this->redis->auth( config("redis.password") ); 
      
      if ($conn) {
        // 选择存放数据库
        $this->redis->select( config("redis.database") );
      }else{
        $this->redis = false;
      }
    }
    // getInstance()方法必须设置为公有的,必须调用此方法
    public static function getInstance(){
        if (self::$_instance===null) {  
            self::$_instance = new self();  //方式二
        }
        return self::$_instance;
    }
    
    public function getRedis(){
        return $this->redis;
    }

    /**
     * 获取当前时间到下周钱的过期时间，单位为秒
    */
    public static function get_nextweek_expiredtime_seconds(){
      date_default_timezone_set("Asia/Shanghai");
      
      //从第几周找出该周的开始日期和结束日期  
      $dayNumber = date('W') * 7;  
      $weekDayNumber = date("w", mktime(0, 0, 0, 1, $dayNumber, date("Y")));//当前周的第几天  
      $startNumber = $dayNumber - $weekDayNumber;  
      // echo date("Y-m-d", mktime(0, 0, 0, 1, $startNumber + 1, date("Y")));//开始日期  
      // echo "\t";
      $end_datetime = date("Y-m-d H:i:s", mktime(0, 0, 0, 1, $startNumber + 8, date("Y")));//结束日期  
      return strtotime($end_datetime) - time('now');
    }
}