<?php

namespace app\common\model;

use think\Model;
use traits\model\SoftDelete;

class Attachment extends Model
{
	use SoftDelete;
	
    // 设置当前模型对应的完整数据表名称
    protected $table = 'mr_attachments';
    // 开启自动写入时间戳字段
    protected $autoWriteTimestamp = 'datetime';
    
    // 定义时间戳字段名
    protected $createTime = 'created_at';
    protected $updateTime = 'updated_at';

    protected $deleteTime = 'deleted_time';

    //隐藏字段
    protected $hidden = ['updated_at','deleted_time'];
    
    public function owner()
    {
        return $this->hasOne('User', 'uid');
    }
}
