<?php

namespace app\api\controller;

use app\common\model\Miniapp as MiniappModel;

class Index extends Base
{
    /**
     * 获取小程序列表
     * @return json
    */
    public function miniapps()
    {
        $apps = MiniappModel::select();
        if ($apps) {
            $data = [];
            foreach ($apps as $key => $app) {
                $data[] = [
                    'id' => intval($app->id),
                    'name' => $app->name,
                    'image' => $app->poster,
                    'btn_color' => $app->btn_color,
                    'title_color' => $app->title_color,
                    'icon' => $app->icon,
                    'qrcode' => $app->qrcode
                ];
            }
            return ["code"=>0, "msg"=>"获取成功", 'data'=>$data];
        }else{
            return ["code"=>1, "msg"=>"没有更多了"];
        }
    }

}