<?php
/**
 * Created by PhpStorm.
 * User: wanggang
 * Date: 2018/9/27
 * Time: 上午3:21
 */

namespace app\admin\controller;
use app\admin\controller\AuthBase;


class User extends AuthBase
{
    public function _initialize()
    {
        parent::_initialize();
    }
    public function index(){
        $nickname = input('get.nickname');
        $is_vip = input('get.is_vip');
        $start_time = input('get.start_time');
        $end_time = input('get.end_time');
        $condition = [];
        if($nickname){
            $condition['nickname'] = ['like','%'.$nickname.'%'];
        }
        if($is_vip){
            $condition['is_vip'] = $is_vip;
        }
        if($start_time&&$end_time){
            $condition['created_at'] = ['between',[$start_time.' 00:00:00',$end_time.' 00:00:00']];
        }else{
            if($start_time){
                $condition['created_at'] = ['>',$start_time.' 00:00:00'];
            }elseif($end_time){
                $condition['created_at'] = ['<',$end_time.' 00:00:00'];
            }
        }

        $user_model = model('user');
        $user_list = $user_model->where($condition)->order('created_at desc')
            ->paginate(10,['query'=>['nickname'=>$nickname,'is_vip'=>$is_vip,'start_time'=>$start_time,'end_time'=>$end_time]]);
        $this->assign('user_list',$user_list);
        return $this->fetch();

    }
}