<?php
namespace app\admin\controller;
use app\admin\controller\AuthBase;

class Order extends AuthBase
{
  protected $order_model;
  public function _initialize()
  {
      parent::_initialize();
      $this->order_model = model('Order');
  }
//  订单列表
  public function index(){
      $status = input('get.status','-1');
      $id = input('get.id');
      $start_time = input('get.start_time');
      $end_time = input('get.end_time');
      $type = input('get.type');
      $condition = [];
      if($status!='-1'){
        $condition['status']=$status;
      }
      if($id){
          $condition['id']=$id;
      }
      if($type){
          $condition['type']=$type;
      }
      if($start_time&&$end_time){
          $condition['created_at'] = ['between',[$start_time.' 00:00:00',$end_time.' 00:00:00']];
      }else{
          if($start_time){
              $condition['created_at'] = ['>',$start_time.' 00:00:00'];
          }elseif($end_time){
              $condition['created_at'] = ['<',$end_time.' 00:00:00'];
          }
      }
      $order_list = $this->order_model->where($condition)->order('created_at desc')->paginate(10,false,['query'=>['status'=>$status,'start_time'=>$start_time,'end_time'=>$end_time,'type'=>$type]]);
      $this->assign("order_list",$order_list);
      $this->assign("status",$status);
      return $this->fetch();
  }
//  退款审核
  public function refund(){
      $id = input('get.id');
      $status = input('get.status','-1');
      $condition = [];
      if($status!='-1'){
          $condition['status']=$status;
      }
      if($id){
          $condition['id']=$id;
      }
      $refund_list =  model('Refund')->where($condition)->order('created_at desc')->paginate(10,false,['query'=>['status'=>$status]]);
      $this->assign('status',$status);
      $this->assign('refund_list',$refund_list);
      return $this->fetch();
  }
//  评论审核
  public function comment(){
      $id = input('get.id');
      $status = input('get.status','-1');
      $condition = [];
      if($status!='-1'){
          $condition['status']=$status;
      }
      if($id){
          $condition['id']=$id;
      }
      $comment_list = model('comment')->where($condition)->order('created_at desc')->paginate(10,false,['query'=>['status'=>$status]]);
      $this->assign('status',$status);
      $this->assign('comment_list',$comment_list);
      return $this->fetch();
  }
  public function commentStatus($status,$id){
      $comment_model = model('comment');
    $res = $comment_model->save(['status'=>$status],['id' => $id]);
    if($status==2){
        $is_comment = 3;
    }elseif($status==3){
        $is_comment = 2;
    }
    $status_str = array(
        '2'=>'请求成功，已审核通过该评论',
        '3'=>'请求成功，该评论审核不通过'
    );
    if($res){
        $comment_info = $comment_model->get($id);
        if($comment_info){
            $set_order_res = model('order')->save(['is_comment'=>$is_comment],['id'=>$comment_info['order_id']]);
        }
        $this->success($status_str[$status]);
    }else{
        $this->error('修改失败，本次审核无效');

    }
  }
}
