<?php
namespace app\admin\controller;
use app\admin\controller\AuthBase;

use app\common\model\Visitor as VisitorModel;
use app\common\model\HomeView as HomeViewModel;
use app\common\model\MiniappView as MiniappViewModel;
use app\common\model\ExpbtnClick as ExpbtnClickModel;

class Index extends AuthBase
{
    public function _initialize()
    {
        parent::_initialize();
    }

    public function index(){
        $user_model = model('user');
        $order_model = model('order');
        $comment_model = model('comment');
        $refund_model = model('refund');

//        统计用户总数
        $user_num = $user_model->count();
        $this->assign('user_num',$user_num);

//        统计今日新增用户数
        $user_num_today = $user_model->where('created_at','>',date('Y-m-d',time()).' 00:00:00')->count();
        $this->assign('user_num_today',$user_num_today);

//        统计订单总数
        $order_num = $order_model->count();
        $this->assign('order_num',$order_num);
//        统计今日订单总数
        $order_num_today = $order_model->where('created_at','>',date('Y-m-d',time()).' 00:00:00')->count();
        $this->assign('order_num_today',$order_num_today);

//        统计待审核退款
        $wait_num_r = $refund_model->where('status',1)->count();
        $this->assign('wait_num_r',$wait_num_r);

//        统计待审核评论
        $wait_num_c = $comment_model->where('status',1)->count();
        $this->assign('wait_num_c',$wait_num_c);

        return view("index");

    }
}