$(function () {
    $('[data-toggle="tooltip"]').tooltip();

    // 右侧详情
    $('.btn-detail').unbind('click').bind('click', function (event) {
        event.stopPropagation();
        event.preventDefault();
        document.getElementById('right-detail-content').innerHTML = "";
        var url = "/admin/Timing/read";
        var oid = $(this).attr('oid');
        showRightDetail(function () {
            $.get(url + "/id/" + oid, function (res) {
                var res = JSON.parse(res);
                console.log(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    var html = template('timing', res.data);
                    document.getElementById('right-detail-content').innerHTML = html;
                }
            });
        });
    });

    // 删除
    $('.btn-delete').unbind('click').bind('click', function (event) {
        var url = "/admin/Timing/delete";
        var oid = $(this).attr('oid');
        showDialog("删除定时任务", "确定删除定时任务？", function () {
            $.get(url + "/id/" + oid, function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    window.location.reload();
                }
            });
        });
    });
});