$(function () {
    $('[data-toggle="tooltip"]').tooltip();

    // 右侧详情
    $('.right-show').unbind('click').bind('click', function (event) {
        event.stopPropagation();
        event.preventDefault();
        document.getElementById('right-detail-content').innerHTML = "";
        var url = "/admin/Activity/readjson";
        var oid = $(this).attr('oid');
        showRightDetail(function () {
            $.get(url + "?id=" + oid, function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    var html = template('acticity', res.data);
                    document.getElementById('right-detail-content').innerHTML = html;
                }
            });
        });
    });

    // 推送
    $('.btn-push').unbind('click').bind('click', function (event) {
        event.preventDefault();
        document.getElementById('right-detail-content').innerHTML = "";
        var url = "/admin/Activity/readSpaces";
        var oid = $(this).attr('oid');
        showRightDetail(function () {
            $.get(url + "/id/" + oid, function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    var html = template('spaces-tmp', res.data);
                    document.getElementById('right-detail-content').innerHTML = html;
                    // 关联并推送
                    $('#btn-publish').unbind('click').bind('click', function (event) {
                        event.preventDefault();
                        var _this = $(this);
                        var $btn = _this.button('loading');
                        var sid = $('#space').val();
                        var auto_publish = $('input[name=auto_publish]:checked').val();
                        if (sid && sid != 0) {
                            publish(oid, sid, auto_publish, $btn);
                        } else {
                            new PNotify({
                                title: '提示',
                                text: '请选择群空间'
                            });
                            $btn.button('reset');
                            return;
                        }
                    });

                    // 删除关联
                    $('.btn-hand-delete').unbind('click').bind('click', function (event) {
                        event.preventDefault();
                        var _this = $(this);
                        var $btn = _this.button('loading');
                        var oid = _this.attr('oid');
                        if (oid && oid != 0) {
                            showDialog("删除", "确定删除活动与群的关联？", function () {
                                deleteSpaceRelation(oid, $btn);
                            }, function () {
                                $btn.button('reset');
                            });
                        } else {
                            new PNotify({
                                title: '提示',
                                text: '参数错误，请刷新'
                            });
                            $btn.button('reset');
                            return;
                        }
                    });
                }
            });
        });
    });

    // 删除
    $('.btn-delete').unbind('click').bind('click', function (event) {
        var url = "/admin/Activity/delete";
        var oid = $(this).attr('oid');
        showDialog("删除活动", "确定删除活动？", function () {
            $.get(url + "?id=" + oid, function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    window.location.reload();
                }
            });
        });
    });

    // 订单详情
    $('.order-show').unbind('click').bind('click', function (event) {
        event.stopPropagation();
        event.preventDefault();
        document.getElementById('right-detail-content').innerHTML = "";
        var url = "/admin/Activity/order";
        var aid = $(this).attr('aid');
        var uid = $(this).attr('uid');
        showRightDetail(function () {
            $.get(url + "?aid=" + aid + "&uid=" + uid, function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    console.log(res);
                    var html = template('order', res.data);
                    document.getElementById('right-detail-content').innerHTML = html;
                }
            });
        });
    });

    /**
     * 发布活动到群空间
     * @param  {[type]} oid [description]
     * @param  {[type]} sid [description]
     * @param  {[type]} btn [description]
     * @return {[type]}     [description]
     */
    function publish(oid, sid, auto, btn) {
        $.ajax({
                url: '/admin/Activity/publish',
                type: 'POST',
                dataType: 'json',
                data: {
                    id: oid,
                    sid: sid,
                    auto_publish: auto
                },
                cache: false
            })
            .done(function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    window.location.reload();
                }
            })
            .fail(function () {
                new PNotify({
                    title: '提示',
                    text: '网络请求失败',
                    'type': 'error'
                });
            })
            .always(function () {
                if (btn) {
                    btn.button('reset');
                };
            });
    }

    /**
     * 删除活动与群关联
     * @param  {[type]} oid [description]
     * @param  {[type]} btn [description]
     * @return {[type]}     [description]
     */
    function deleteSpaceRelation(oid, btn) {
        $.ajax({
                url: '/admin/Activity/deleteSpaceRelation',
                type: 'POST',
                dataType: 'json',
                data: {
                    id: oid
                },
                cache: false
            })
            .done(function (res) {
                var res = JSON.parse(res);
                if (res.error) {
                    new PNotify({
                        title: '提示',
                        text: res.msg,
                        'type': 'error'
                    });
                } else {
                    window.location.reload();
                }
            })
            .fail(function () {
                new PNotify({
                    title: '提示',
                    text: '网络请求失败',
                    'type': 'error'
                });
            })
            .always(function () {
                if (btn) {
                    btn.button('reset');
                };
            });
    }
});