<?php

namespace app\mob\controller;

use app\common\model\Business;
use app\mob\controller\Base;
use think\Validate;


class Index extends Base
{
    /**
     * 首页
     */
    public function index($id = 0)
    {
        return view();
    }

    /**
     * 用户使用协议
     */
    public function agreement()
    {
        $this->redirect(url('@mob/Post/read', ['id' => 5]));
    }

    /**
     * 使用帮助
     */
    public function help()
    {
        $this->redirect(url('@mob/Post/read', ['id' => 2]));
    }

    /**
     * 商家入驻
     */
    public function shopjoin()
    {
        return view();
    }

    public function businessJoin()
    {
        $validate = Validate::make([
            ['business_name', 'require', '请输入商家名称'],
            ['business_type', 'require', '请输入商家类型'],
            ['contacts', 'require', '请输入您的姓名'],
            ['phone', 'require', '请输入您的手机号'],
            ['wx_number', 'require', '请输入您的微信号'],
        ]);
        $result                  = $validate->check(input('post.'));
        //校验
        if(!$result){
            return json(['code'=>1,'msg'=>$validate->getError()]);
        }
        $business                = new Business();
        $business->business_name = input('post.business_name');
        $business->business_type = input('post.business_type');
        $business->contacts      = input('post.contacts');
        $business->phone         = input('post.phone');
        $business->wx_number     = input('post.wx_number');
        $business->remark        = input('post.remark', '');
        $business->save();
        return json(['code'=>1,'msg'=>'入住信息提交成功']);
    }

}





