<?php
namespace app\common\utils;

/**
* 网络请求帮助类
*/
class HttpHelper
{
    /**
     * [post_json description]
     * @param  [type] $url    [description]
     * @param  [type] $data   [description]
     * @param  [type] $header [description]
     * @return [type]         [description]
     */
    public static function post_json($url, $data, $header)
    {
        // 创建一个新cURL资源
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $url);
        // 此处有大坑，加上此句保证输出的是结果而不是0/1
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // 使用POST
        curl_setopt($ch, CURLOPT_POST, true);
        // POST的变量
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HEADER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

        $json = curl_exec($ch); //获取结果
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);
        return $json;
    }

    /**
     * [post_json_decode description]
     * @param  [type] $url  [description]
     * @param  [type] $data [description]
     * @return [type]       [description]
     */
    public static function post_json_decode($url, $data)
    {
        // 创建一个新cURL资源
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $url);
        // 此处有大坑，加上此句保证输出的是结果而不是0/1
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        // 使用POST
        curl_setopt($ch, CURLOPT_POST, true);
        // POST的变量
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        $result = curl_exec($ch); //获取结果
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_code !== 200) {
            return array();
        }
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);

        $data = json_decode($result);
        return $data;
    }

    /**
     * post_x_www_form_urlencoded
     * @param  [type] $url  [description]
     * @param  Array  $data [description]
     * @return [type]       [description]
     */
    public static function post_x_www_form_urlencoded($url, Array $data)
    {
        // 创建一个新cURL资源
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // 使用POST
        curl_setopt($ch, CURLOPT_POST, true);
        // POST的变量
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/x-www-form-urlencoded"]);

        $json = curl_exec($ch); //获取结果
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);
        return $json;
    }

    /**
     * post_xml
     * @param  [type] $url  [description]
     * @param  [type] $data [description]
     * @return [type]       [description]
     */
    public static function post_xml($url, $data)
    {
        // 创建一个新cURL资源
        $ch = curl_init();

        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        // 使用POST
        curl_setopt($ch, CURLOPT_POST, true);
        // POST的变量
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: text/xml"]);

        $xml = curl_exec($ch); //获取结果
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);
        return $xml;
    }

    /**
     * post ssl
     * @param  [type]  $url     [description]
     * @param  [type]  $vars    [description]
     * @param  integer $second  [description]
     * @param  array   $aHeader [description]
     * @return [type]           [description]
     */
    public static function post_ssl($url, $vars, $second=30,$aHeader=array())
    {
        $ch = curl_init();
        //超时时间
        curl_setopt($ch,CURLOPT_TIMEOUT,$second);
        curl_setopt($ch,CURLOPT_RETURNTRANSFER, 1);
        //这里设置代理，如果有的话
        // curl_setopt($ch,CURLOPT_PROXY, '10.206.30.98');
        // curl_setopt($ch,CURLOPT_PROXYPORT, 8080);
        curl_setopt($ch,CURLOPT_URL,$url);
        curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
        curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,false);
      
        //以下两种方式需选择一种
      
        //第一种方法，cert 与 key 分别属于两个.pem文件
        //默认格式为PEM，可以注释
        curl_setopt($ch,CURLOPT_SSLCERTTYPE,'PEM');
        curl_setopt($ch,CURLOPT_SSLCERT,getcwd().'/../key/apiclient_cert.pem');
        //默认格式为PEM，可以注释
        curl_setopt($ch,CURLOPT_SSLKEYTYPE,'PEM');
        curl_setopt($ch,CURLOPT_SSLKEY,getcwd().'/../key/apiclient_key.pem');
        \Log::info('post ssl key path:');
        \Log::info(getcwd().'/key/apiclient_key.pem');
      
        //第二种方式，两个文件合成一个.pem文件
        // curl_setopt($ch,CURLOPT_SSLCERT,getcwd().'/all.pem');
     
        if( count($aHeader) >= 1 ){
            curl_setopt($ch, CURLOPT_HTTPHEADER, $aHeader);
        }
     
        curl_setopt($ch,CURLOPT_POST, 1);
        curl_setopt($ch,CURLOPT_POSTFIELDS,$vars);
        $data = curl_exec($ch);
        if($data){
            curl_close($ch);
            return $data;
        } else { 
            $error = curl_errno($ch);
            echo "call faild, errorCode:$error\n"; 
            curl_close($ch);
            return false;
        }
    }

    /**
     * [get_curl description]
     * @param  [type] $url    [description]
     * @param  [type] $header [description]
     * @return [type]         [description]
     */
    public static function get_curl($url, $header)
    {
        // 创建一个新cURL资源
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, false);

        curl_setopt($ch, CURLOPT_HEADER, true); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        
        $json = curl_exec($ch); //获取结果
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);
        return $json;
    }

    /**
     * [get_curl description]
     * @param  [type] $url    [description]
     * @param  [type] $header [description]
     * @return [type]         [description]
     */
    public static function get_curl_json($url, $header)
    {
        // 创建一个新cURL资源
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, false);

        // curl_setopt($ch, CURLOPT_HEADER, true); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        
        $json = curl_exec($ch); //获取结果
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);
        return $json;
    }

    public static function get_json_decode($url)
    {
        // 创建一个新cURL资源
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $url);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, false);

        $result = curl_exec($ch); //获取结果
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        if ($http_code !== 200) {
            return array();
        }
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);

        $data = json_decode($result);
        return $data;
    }
}