<?php
/**
 * Created by PhpStorm.
 * User: 30868
 * Date: 2018/9/14
 * Time: 2:38
 */

namespace app\common\model;

use app\common\model\BaseModel;
use think\Collection;
use traits\model\SoftDelete;
use app\common\model\Project as ProjectModel;
use app\common\model\User as UserModel;

class Order extends BaseModel
{
    use SoftDelete;
    // 设置当前模型对应的完整数据表名称
    protected $table = 'mr_user_orders';

//    订单退款信息
    public function linkrefund(){
        return $this->hasOne('refund','order_id','id')->field('id');
    }
    //    订单退款信息
    public function linkcomment(){
        return $this->hasOne('comment','order_id','id')->field('id');
    }


    //获取订单商品
    public function project()
    {
        return $this->belongsTo('Project', 'pid', 'id');
    }

    //获取下单用户信息
    public function userInfo()
    {
        return $this->belongsTo('User', 'uid', 'id');
    }

    //处理订单状态
    public function getStatusNameAttr($value, $data)
    {
        $statusNameArr = array(
            '0' => ['color' => '#cc2e2e', 'name' => '待付款'],
            '1' => ['color' => '#c33eff', 'name' => '进行中'],
            '2' => ['color' => '#68dff0', 'name' => '待评价'],
            '3' => ['color' => '#4acc2e', 'name' => '已完成']
        );
        return $statusNameArr[$data['status']];
//        0-未付款，1-进行中，2-待评价，3-已完成
    }

    //extras转化成数组
    public function getExtrasAttr($value)
    {
        return json_decode($value, true);
    }

    //转化成json
    public function setExtrasAttr($value)
    {
        return json_encode($value);
    }

    //检验家庭组限制->已上锁
    public static function getGroupNumberByProject($pid, $sign_limits)
    {
        //获取家庭组限制
        $project = ProjectModel::lock(true)->find($pid);
        if ($project['sign_limits'] >= intval($project['sign_num'])+$sign_limits) {
            return true;
        }
        return false;
    }

    //订单状态
    public function getStatusTextAttr($value,$data)
    {
        $str = '';
        if($data['status'] == config('order_status.pay')){
            //进行中
            if($data['is_refund'] == config('refund_status.no')){
                $str = '申请退款';
            }elseif($data['is_refund'] == config('refund_status.to_examine')){
                $str = '退款申请中';
            }elseif($data['is_refund'] == config('refund_status.no_pass')){
                $str = '退款失败';
            }
        }elseif($data['status'] == config('order_status.wait_comment')){
            //待评价
            if($data['is_comment'] == config('comment_status.no')){
                $str = '待评价';
            }elseif($data['is_comment'] == config('comment_status.to_examine')){
                $str = '评价审核中';
            }elseif($data['is_comment'] == config('comment_status.no_pass')){
                $str = '评价失败';
            }
        }elseif($data['status'] == config('order_status.complete')){
            //待评价
            if($data['is_comment'] == config('comment_status.pass')){
                $str = '已完成';
            }
            if($data['is_refund'] == config('refund_status.pass')){
                $str = '已退款';
            }
        }
        return $str;
    }

}
