<?php
namespace app\admin\validate;
use think\Validate;
class Project extends Validate
{
    protected $rule = [
        ['name','require|max:30','名称必须传递|名称不能超过30个字符'],
        ['sort','number','序号必须为数字'],
        ['id','require|number','缺少必要参数ID'],
        ['status','number|in:-1,0,1','状态必须是数字|状态范围不合法'],
        ['poster','require','图片必须上传'],
    ];
//    场景设置
    protected $scene = [
        'addTag' => ['name','sort'],
        'updateTag' => ['name','sort','id'],
        'addCatalogs' => ['name','sort','poster']
    ];

}
