<?php
/**
 * Created by PhpStorm.
 * User: 30868
 * Date: 2018/9/15
 * Time: 1:05
 */

namespace app\admin\validate;

use think\Validate;

class Post extends Validate
{
    protected $rule = [
        ['title','require','文章标题不能为空'],
        ['sort','number','序号必须为数字'],
        ['id','require','缺少必要参数ID'],
        ['status','number|in:-1,0,1','状态必须是数字|状态范围不合法'],
        ['content','require','文章内容不能为空'],
        ['poster','require','文章封面必须上传']
    ];
//    场景设置
    protected $scene = [
        'create' => ['title','content','poster'],
        'update' => ['title','content']
    ];
}
