<?php
/**
 * Created by PhpStorm.
 * User: wanggang
 * Date: 2018/9/27
 * Time: 上午3:21
 */

namespace app\admin\controller;
use app\admin\controller\AuthBase;
use app\admin\controller\OutputExcel;

class User extends AuthBase
{
    public function _initialize()
    {
        parent::_initialize();
    }
    public function index(){
        $nickname = input('get.nickname');
        $is_vip = input('get.is_vip');
        $start_time = input('get.start_time');
        $end_time = input('get.end_time');
        $phone = input('get.phone');
        $condition = [];
        if($nickname){
            $condition['nickname'] = ['like','%'.$nickname.'%'];
        }
        if($is_vip){
            $condition['is_vip'] = $is_vip;
        }
        if($phone){
            $condition['phone'] = $phone;
        }
        if($start_time&&$end_time){
            $condition['created_at'] = ['between',[$start_time.' 00:00:00',$end_time.' 00:00:00']];
        }else{
            if($start_time){
                $condition['created_at'] = ['>',$start_time.' 00:00:00'];
            }elseif($end_time){
                $condition['created_at'] = ['<',$end_time.' 00:00:00'];
            }
        }

        $user_model = model('user');
        $user_list = $user_model->where($condition)->order('created_at desc')
            ->paginate(10,['query'=>['nickname'=>$nickname,'is_vip'=>$is_vip,'start_time'=>$start_time,'end_time'=>$end_time,'phone'=>$phone]]);
        $this->assign('user_list',$user_list);
        return $this->fetch();

    }
    public function userOutPut(){
        $nickname = input('get.nickname');
        $is_vip = input('get.is_vip');
        $start_time = input('get.start_time');
        $end_time = input('get.end_time');
        $condition = [];
        if($nickname){
            $condition['nickname'] = ['like','%'.$nickname.'%'];
        }
        if($is_vip){
            $condition['is_vip'] = $is_vip;
        }
        if($start_time&&$end_time){
            $condition['created_at'] = ['between',[$start_time.' 00:00:00',$end_time.' 00:00:00']];
        }else{
            if($start_time){
                $condition['created_at'] = ['>',$start_time.' 00:00:00'];
            }elseif($end_time){
                $condition['created_at'] = ['<',$end_time.' 00:00:00'];
            }
        }
        $user_list = model('user')->where($condition)->field('nickname,gender,phone,is_vip,created_at,updated_at,vip_endtime')->select();
        $mulit_arr = [];
        $mulit_arr['data'] = [];
        $cont = [['昵称','性别','电话','是否是会员','注册时间','更新时间','会员到期时间']];
//            [
//                'data'=>
//                    [
//                        [
//                            ['昵称','性别','电话','是否是会员','注册时间','更新时间','会员到期时间'],
//                            ['a','b','c'],
//                            ['d','e','f']
//                        ]
//                    ],
            //        'sheet'=>
            //   [
            //       ['title'=>'工作空间1名称']，
            //        ['title'=>'工作空间2名称']，
            //   ]
//            ];
        foreach ($user_list as $vo){
            $arr = [];
            $arr[] = $vo['nickname'];
            $arr[] = $vo['gender']==1?'男':'女';
            $arr[] = $vo['phone'];
            $arr[] = $vo['is_vip']==0?'否':'是';
            $arr[] = $vo['created_at'];
            $arr[] = $vo['updated_at'];
            $arr[] = $vo['vip_endtime'];
            $cont[] = $arr;
        }
        $mulit_arr['data'][] =$cont;
        $mulit_arr['sheet'] = [['title'=>'用户信息表']];
//        dump($mulit_arr);
//        return;
        /*调用*/
        $title = '用户表';//这是标题
        $Subject='';//这是备注
        $Description='美行者用户导出';//这是描述;
        $Keywords='';//这是关键字
        $Category='';//这是分类
        $filename = '美行者用户导出';//文件名
        $obj = new OutputExcel();
        $obj->export($mulit_arr,$filename,$title,$Subject,$Description,$Keywords,$Category);
    }
}