<?php
namespace app\admin\controller;

use think\Db;
use app\admin\controller\AuthBase;
use app\common\model\Post as PostModel;
use app\common\model\Admin as AdminModel;
use app\admin\controller\Upload;

class Post extends AuthBase
{
    public function index()
    {
        $title = input('title');
        $map = array();

        // 模糊查询title
        if ($title) {
            $map['title'] = ['like', "%".$title."%"];
        }
        $posts = PostModel::where($map)->order('id desc')->paginate(10);

        $this->assign('articles', $posts);
        return view("index");
    }

    public function create()
    {
        $tag_model = model("tags");
        $tag_list = $tag_model -> order('sort','asc') -> select();
        $this -> assign('tag_list', $tag_list);
        if (request()->isPost()) {
            $type = input("post.type");
            $data = array(
                'title' => input("post.title"),
                'tags' => input("post.tags"),
                'poster' => input('file.poster')
            );
            if($type == 1){
                $data['content'] =input("post.content");
            }else{
                $data['content'] =input("post.href");
            }
            $validate = validate('Post');
            if (!$validate->scene('create')->check($data)) {
                $msg = $validate->getError();
                $this->assign('msg', $msg);
                return view();
            }
//            上传封面到七牛云
            $upload = new Upload();
            $result =  $upload -> sava(input('file.poster'));
            if($result['error']){
                $this->assign('msg', $result['error']);
                return view();
            }
            $article = new PostModel([
                'admin_id' => intval(session('uid')),
                'poster' => $result['result']['url'],
                'tags' => $data['tags'],
                'title' => $data['title'],
                'type' => $type,
                'content' => htmlspecialchars($data['content'])
            ]);
            if ($article->save()) {
                $this->redirect(url('@admin/Post/index'));
             } else {
                return view();
             }
        } else {
            return view();
        }
    }

    /**
     * 修改文章
     *
     * @return \think\Response
     */
    public function update($id)
    {
        $article = PostModel::get($id);
        if (request()->isPost()) {
            if (!$article) {
                $this->error('文章不存在！');
                echo "404";
            }
            $data = input("post.");

            if (!trim(input("post.title")) || !trim(input("post.content")) ) {
                $msg = "标题和内容不为空！";
                $this->assign('msg', $msg);
                $this->assign('article', $article);
                return view();
            }

            $article->title = $data['title'];
            $article->content = htmlspecialchars($data['content']);
            $article->admin_id = intval(session('uid'));

            if ($article->save()) {
                $this->redirect(url('@admin/Post/index'));
            } else {
                $this->assign('article', $article);
                return view();
            }
        }else{
            $this->assign('article', $article);
            return view();
        }
    }

    /**
     * 删除文章
     *
     * @return \think\Response
    */
    public function delete()
    {
        $result["error"] = 0;
        $result["msg"] = '删除成功';

        if( request()->isPost() ) {
            $id = input("post.id");
            $article = PostModel::get($id);
            if( $article ) {
                if( $article->delete() ){

                }else{
                    $result["error"] = 1;
                    $result["msg"] = '删除失败！';
                }
            }else{
                $result["error"] = 1;
                $result["msg"] = '删除对象不存在';
            }
        }else{
            $result["error"] = 1;
            $result["msg"] = '不支持的请求方法';
        }
        echo json_encode($result);
    }

}
