package cn.iocoder.foodnexus.module.product.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author : yanghao
 * create at:  2025/9/5  17:32
 * @description: 商品信息
 */
@Data
public class ProductInfo implements Serializable {


    /**
     * 商品 SPU 编号，自增
     */
    private Long id;

    // ========== 基本信息 =========

    /**
     * 商品名称
     */
    private String name;
    /**
     * 商品规格
     */
    private String introduction;
    /**
     * 商品详情
     */
    private String description;

    /**
     * 商品分类编号
     *
     */
    private Long categoryId;
    /**
     * 分类名称
     */
    private String categoryName;
    /**
     * 商品封面图
     */
    private String picUrl;

    /**
     * 排序字段
     */
    private Integer sort;

    /**
     * 商品单位
     */
    private String unitName;
}
