package cn.iocoder.foodnexus.module.order.dal.dataobject.customerorderrecord;

import cn.iocoder.foodnexus.module.order.enums.CustomerOrderStatus;
import lombok.*;
import java.util.*;
import java.time.LocalDateTime;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.*;
import cn.iocoder.foodnexus.framework.mybatis.core.dataobject.BaseDO;

/**
 * 客户订单进度记录 DO
 *
 * @author 超级管理员
 */
@TableName(value = "order_customer_order_record", autoResultMap = true)
@KeySequence("order_customer_order_record_seq") // 用于 Oracle、PostgreSQL、Kingbase、DB2、H2 数据库的主键自增。如果是 MySQL 等数据库，可不写。
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CustomerOrderRecordDO extends BaseDO {

    /**
     * id
     */
    @TableId
    private Long id;
    /**
     * 客户订单id
     */
    private Long customerOrderId;
    /**
     * 订单状态
     *
     * 枚举 {@link CustomerOrderStatus}
     */
    private CustomerOrderStatus orderStatus;
    /**
     * 客户id
     */
    private Long customerId;
    /**
     * 供应商id
     */
    private Long supplierId;
    /**
     * 信息
     */
    private String messageInfo;
    /**
     * 扩展信息
     */
    private String extendInfo;


}